/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.datasource;

import com.dynamic.sql.anno.DBSource;
import com.dynamic.sql.datasource.DataSourceMapping;
import com.dynamic.sql.utils.NamingUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceScanner {
    private static final Logger log = LoggerFactory.getLogger(DataSourceScanner.class);

    private DataSourceScanner() {
    }

    protected static List<DataSourceMapping> findDataSource(String forPackage) {
        log.debug("Find the data source based on the provided '{}' path. ", (Object)forPackage);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)forPackage, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(forPackage)).setScanners(new Scanner[]{Scanners.MethodsAnnotated, Scanners.TypesAnnotated}));
        Set methods = reflections.getMethodsAnnotatedWith(DBSource.class);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(DBSource.class);
        ArrayList<DataSourceMapping> dataSources = new ArrayList<DataSourceMapping>();
        try {
            DBSource dbSource;
            for (Method method : methods) {
                Object instance = method.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object invoke = method.invoke(instance, new Object[0]);
                dbSource = method.getAnnotation(DBSource.class);
                dataSources.add(DataSourceScanner.dataSourceMapping(invoke, dbSource, method.getName()));
            }
            for (Class annotatedClass : annotatedClasses) {
                Constructor constructor = annotatedClass.getDeclaredConstructor(new Class[0]);
                Object instance = constructor.newInstance(new Object[0]);
                dbSource = annotatedClass.getAnnotation(DBSource.class);
                dataSources.add(DataSourceScanner.dataSourceMapping(instance, dbSource, annotatedClass.getSimpleName()));
            }
            if (log.isDebugEnabled()) {
                for (DataSourceMapping dataSourceMapping : dataSources) {
                    log.debug("Found the data source, named: {}.", (Object)dataSourceMapping.getDataSourceName());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An exception occurred while retrieving the data source.", e);
        }
        return dataSources;
    }

    private static DataSourceMapping dataSourceMapping(Object instance, DBSource dbSource, String methodOrClassName) {
        if (!(instance instanceof DataSource)) {
            throw new IllegalStateException("The data source class must return an implementation of DataSource");
        }
        String beanName = NamingUtils.getBeanName(dbSource.value(), methodOrClassName);
        DataSource dataSource = (DataSource)instance;
        return new DataSourceMapping(beanName, dataSource, dbSource.defaultDB(), dbSource.basePackages());
    }
}

