/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination;

import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.CollectionPage;
import com.dynamic.sql.plugins.pagination.LocalPage;
import com.dynamic.sql.plugins.pagination.MapPage;
import com.dynamic.sql.plugins.pagination.PageInfo;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageHelper {
    private static final Logger log = LoggerFactory.getLogger(PageHelper.class);

    private PageHelper() {
    }

    public static GeneralPageHelper of(int pageIndex, int pageSize) {
        PageHelper.checkPageParams(pageIndex, pageSize);
        return new GeneralPageHelper(Math.max(pageIndex, 1), pageSize);
    }

    public static CollectionPageHelper ofCollection(int pageIndex, int pageSize) {
        PageHelper.checkPageParams(pageIndex, pageSize);
        return new CollectionPageHelper(Math.max(pageIndex, 1), pageSize);
    }

    public static MapPageHelper ofMap(int pageIndex, int pageSize) {
        PageHelper.checkPageParams(pageIndex, pageSize);
        return new MapPageHelper(Math.max(pageIndex, 1), pageSize);
    }

    static <T> GeneralPageHelper of(PageInfo<T> pageInfo) {
        return new GeneralPageHelper(pageInfo);
    }

    static <C extends Collection<T>, T> CollectionPageHelper ofCollection(CollectionPage<C, T> collectionPage) {
        return new CollectionPageHelper(collectionPage);
    }

    static <K, V, M extends Map<K, V>> MapPageHelper ofMap(MapPage<K, V, M> mapPage) {
        return new MapPageHelper(mapPage);
    }

    private static void checkPageParams(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            log.warn("Invalid pageIndex: {}, setting to 1", (Object)pageIndex);
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be >= 1");
        }
    }

    static void executeQuery(AbstractPage abstractPage, Supplier<?> selectSupplier) {
        LocalPage.setCurrentPage(abstractPage);
        try {
            abstractPage.setRecords(selectSupplier);
        }
        finally {
            LocalPage.clearCurrentPage();
        }
    }

    public static class GeneralPageHelper {
        private int pageIndex;
        private int pageSize;
        private PageInfo<?> cachePageInfo;

        private GeneralPageHelper(int pageIndex, int pageSize) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
        }

        private <T> GeneralPageHelper(PageInfo<T> pageInfo) {
            this.cachePageInfo = pageInfo;
        }

        public <T> PageInfo<T> selectPage(Supplier<T> selectSupplier) {
            PageInfo<Object> pageInfo = this.cachePageInfo == null ? new PageInfo(this.pageIndex, this.pageSize) : this.cachePageInfo;
            PageHelper.executeQuery(pageInfo, selectSupplier);
            return pageInfo;
        }
    }

    public static class MapPageHelper {
        private int pageIndex;
        private int pageSize;
        private MapPage<?, ?, ?> cacheMapPage;

        private MapPageHelper(int pageIndex, int pageSize) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
        }

        private <K, V, M extends Map<K, V>> MapPageHelper(MapPage<K, V, M> mapPage) {
            this.cacheMapPage = mapPage;
        }

        public <K, V, M extends Map<K, V>> MapPage<K, V, M> selectPage(Supplier<M> selectSupplier) {
            MapPage<Object, Object, Object> mapPage = this.cacheMapPage == null ? new MapPage(this.pageIndex, this.pageSize) : this.cacheMapPage;
            PageHelper.executeQuery(mapPage, selectSupplier);
            return mapPage;
        }
    }

    public static class CollectionPageHelper {
        private int pageIndex;
        private int pageSize;
        private CollectionPage<?, ?> cacheCollectionPage;

        private CollectionPageHelper(int pageIndex, int pageSize) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
        }

        private <C extends Collection<T>, T> CollectionPageHelper(CollectionPage<C, T> collectionPage) {
            this.cacheCollectionPage = collectionPage;
        }

        public <C extends Collection<T>, T> CollectionPage<C, T> selectPage(Supplier<C> selectSupplier) {
            CollectionPage<Object, Object> collectionPage = this.cacheCollectionPage == null ? new CollectionPage(this.pageIndex, this.pageSize) : this.cacheCollectionPage;
            PageHelper.executeQuery(collectionPage, selectSupplier);
            return collectionPage;
        }
    }
}

