/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination;

import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.PageHelper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class PageInfo<T>
extends AbstractPage {
    private T records;

    protected PageInfo(int pageIndex, int pageSize) {
        super(pageIndex, pageSize);
    }

    @Override
    void setRecords(Supplier<?> selectSupplier) {
        this.records = selectSupplier.get();
    }

    public T getRecords() {
        return this.records;
    }

    @Override
    public int getRealSize() {
        if (this.records instanceof Collection) {
            return ((Collection)this.records).size();
        }
        if (this.records instanceof Map) {
            return ((Map)this.records).size();
        }
        throw new IllegalStateException("Unsupported records type: " + this.records.getClass().getCanonicalName());
    }

    public PageInfo<T> selectNextPage(Supplier<T> selectSupplier) {
        ++this.pageIndex;
        return PageHelper.of(this).selectPage(selectSupplier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PageInfo{");
        sb.append("pageIndex=").append(this.pageIndex);
        sb.append(", pageSize=").append(this.pageSize);
        sb.append(", realSize=").append(this.getRealSize());
        sb.append(", total=").append(this.total);
        sb.append(", totalPage=").append(this.totalPage);
        sb.append(", records=").append(this.records);
        sb.append('}');
        return sb.toString();
    }
}

