/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.dml.select.SelectHandler;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.interceptor.ExecutionControl;
import com.dynamic.sql.interceptor.SqlInterceptor;
import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.DialectPagination;
import com.dynamic.sql.plugins.pagination.LocalPage;
import com.dynamic.sql.plugins.pagination.impl.MySQLDialectPagination;
import com.dynamic.sql.plugins.pagination.impl.OracleDialectPagination;
import com.dynamic.sql.utils.SqlUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public class PageInterceptorPlugin
implements SqlInterceptor {
    @Override
    public ExecutionControl beforeExecution(SqlStatementWrapper sqlStatementWrapper, Connection connection) {
        DialectPagination dialectPagination;
        AbstractPage currentPage = LocalPage.getCurrentPage();
        if (currentPage == null) {
            return ExecutionControl.PROCEED;
        }
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(sqlStatementWrapper.getDataSourceName());
        Version version = new Version(schemaProperties.getMajorVersionNumber(), schemaProperties.getMinorVersionNumber(), schemaProperties.getPatchVersionNumber());
        SqlDialect sqlDialect = schemaProperties.getSqlDialect();
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                dialectPagination = new MySQLDialectPagination();
                break;
            }
            case ORACLE: {
                dialectPagination = new OracleDialectPagination();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported sql dialect: " + (Object)((Object)sqlDialect));
            }
        }
        AbstractPage abstractPage = LocalPage.getCurrentPage();
        Long total = abstractPage.getCacheTotal();
        if (total == null) {
            total = this.executeCountSql(sqlStatementWrapper, connection, dialectPagination.selectCountSql(version, sqlStatementWrapper));
            currentPage.setTotal(total);
            currentPage.initTotalPage();
        }
        if (total == 0L) {
            return ExecutionControl.SKIP;
        }
        if (abstractPage.getPageIndex() > abstractPage.getTotalPage()) {
            return ExecutionControl.SKIP;
        }
        dialectPagination.modifyPagingSql(version, sqlStatementWrapper, abstractPage.getPageIndex(), abstractPage.getPageSize());
        return ExecutionControl.PROCEED;
    }

    @Override
    public void afterExecution(PreparedSql preparedSql, Object applyResult, Exception exception) {
    }

    private long executeCountSql(SqlStatementWrapper sqlStatementWrapper, Connection connection, StringBuilder countSql) {
        PreparedSql preparedSql = SqlUtils.parsePreparedObject(countSql, sqlStatementWrapper.getParameterBinder());
        List resultCountList = SqlExecutionFactory.applySql(DMLType.SELECT, sqlStatementWrapper.getDataSourceName(), connection, preparedSql, true, SelectHandler::executeQuery);
        if (resultCountList.isEmpty()) {
            return 0L;
        }
        Map.Entry countMap = ((Map)resultCountList.get(0)).entrySet().iterator().next();
        return Long.parseLong(countMap.getValue().toString());
    }
}

