/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination.impl;

import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.plugins.pagination.DialectPagination;
import com.dynamic.sql.utils.SqlUtils;

public class MySQLDialectPagination
implements DialectPagination {
    @Override
    public StringBuilder selectCountSql(Version version, SqlStatementWrapper sqlStatementWrapper) {
        StringBuilder selectCountSql = new StringBuilder(sqlStatementWrapper.getRawSql());
        selectCountSql.insert(0, "select count(1) from (");
        selectCountSql.append(") _count_page_temp ");
        return selectCountSql;
    }

    @Override
    public void modifyPagingSql(Version version, SqlStatementWrapper sqlStatementWrapper, int pageIndex, int pageSize) {
        StringBuilder selectPageSql = sqlStatementWrapper.getRawSql();
        selectPageSql.insert(0, "select * from (");
        selectPageSql.append(") _page_temp limit ");
        ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
        int offset = (pageIndex - 1) * pageSize;
        String offsetKey = SqlUtils.registerValueWithKey(parameterBinder, offset);
        String pageSizeKey = SqlUtils.registerValueWithKey(parameterBinder, pageSize);
        selectPageSql.append(offsetKey);
        selectPageSql.append(", ");
        selectPageSql.append(pageSizeKey);
    }
}

