/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.core.Fn;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    public static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    public static final Pattern START_UPPER_PATTERN = Pattern.compile("^[A-Z].*");
    public static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return ReflectUtils.getAllFields(clazz, null);
    }

    public static List<Field> getAllFields(Class<?> clazz, Function<Field, Boolean> filterRules) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectUtils.collectFields(clazz, fields, filterRules);
        return fields;
    }

    private static void collectFields(Class<?> clazz, List<Field> fields, Function<Field, Boolean> filterRules) {
        Field[] declaredFields;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (filterRules == null) {
                fields.add(field);
                continue;
            }
            if (!Boolean.TRUE.equals(filterRules.apply(field))) continue;
            fields.add(field);
        }
        ReflectUtils.collectFields(clazz.getSuperclass(), fields, filterRules);
    }

    public static String fnToFieldName(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String getter = serializedLambda.getImplMethodName();
        if (GET_PATTERN.matcher(getter).matches()) {
            getter = getter.substring(3);
        } else if (IS_PATTERN.matcher(getter).matches()) {
            getter = getter.substring(2);
        } else if (getter.startsWith("get")) {
            getter = getter.substring(3);
        }
        getter = Introspector.decapitalize(getter);
        if (START_UPPER_PATTERN.matcher(getter).matches()) {
            String begin = getter.substring(0, 1).toLowerCase();
            String end = getter.substring(1);
            getter = begin + end;
        }
        return getter;
    }

    public static String getOriginalClassCanonicalName(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String implClass = serializedLambda.getImplClass();
        if (implClass == null || implClass.isEmpty()) {
            throw new IllegalStateException("Unable to obtain the implementation class");
        }
        return implClass.replace("/", ".");
    }

    public static <C> Class<C> getReturnTypeFromSignature(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String implMethodSignature = serializedLambda.getImplMethodSignature();
        String returnTypeDescriptor = implMethodSignature.substring(implMethodSignature.indexOf(41) + 1);
        String className = ReflectUtils.descriptorToClassName(returnTypeDescriptor);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class for name: " + className, e);
        }
    }

    private static String descriptorToClassName(String descriptor) {
        if (descriptor.startsWith("L") && descriptor.endsWith(";")) {
            return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
        }
        throw new IllegalArgumentException("Unsupported descriptor: " + descriptor);
    }

    private static SerializedLambda serializedLambda(Fn fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)fn, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.warn(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static List<Class<?>> getGenericTypes(Class<?> clazz) {
        return ReflectUtils.getGenericTypes(clazz, null);
    }

    public static List<Class<?>> getGenericTypes(Class<?> clazz, Class<?> ... filterRawType) {
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        ArrayList types = new ArrayList();
        ArrayList filterRawTypeList = new ArrayList();
        if (filterRawType != null && filterRawType.length > 0) {
            filterRawTypeList.addAll(Arrays.asList(filterRawType));
        }
        for (Type type : genericInterfaces) {
            Type[] actualTypeArguments;
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type actualTypeArgument : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (filterRawTypeList.isEmpty()) {
                    types.add((Class)actualTypeArgument);
                    continue;
                }
                if (!filterRawTypeList.contains((Class)parameterizedType.getRawType())) continue;
                types.add((Class)actualTypeArgument);
            }
        }
        return types;
    }

    public static <T> T instance(Class<T> clazz, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of class: " + clazz.getName(), e);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void setFieldValue(Object target, Field field, Object value) {
        try {
            if (!Modifier.isPublic(field.getModifiers())) {
                ReflectUtils.makeAccessible(field);
            }
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getFieldValue(Object target, Field field) {
        try {
            if (!Modifier.isPublic(field.getModifiers())) {
                ReflectUtils.makeAccessible(field);
            }
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> loadClass(String classCanonicalName) {
        try {
            return Class.forName(classCanonicalName);
        }
        catch (ClassNotFoundException e) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(classCanonicalName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(new ClassNotFoundException(classCanonicalName));
        }
    }
}

