/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.GroupFn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.AbstractAliasHelper;
import com.dynamic.sql.core.column.function.AnonymousFunction;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.MysqlWhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.OracleWhereCondition;
import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.dml.select.Select;
import com.dynamic.sql.core.dml.select.build.GenericSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.MysqlSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.OracleSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.order.CustomOrderBy;
import com.dynamic.sql.core.dml.select.order.DefaultOrderBy;
import com.dynamic.sql.core.dml.select.order.OrderBy;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.datasource.DataSourceMeta;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.enums.DbType;
import com.dynamic.sql.enums.JoinTableType;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    private SqlUtils() {
    }

    public static String getSqlTypeQuotes(SqlDialect sqlDialect) {
        if (sqlDialect == null) {
            throw new IllegalArgumentException("Get Sql type quotes not accepting null values");
        }
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "`";
            }
            case ORACLE: 
            case POSTGRESQL: {
                return "\"";
            }
            case SQLSERVER: {
                return "[]";
            }
        }
        throw new IllegalArgumentException("Get Sql type quotes not accepting " + (Object)((Object)sqlDialect));
    }

    public static String quoteIdentifier(SqlDialect sqlDialect, String identifier) {
        if (StringUtils.isEmpty(identifier)) {
            throw new IllegalArgumentException("Identifier cannot be empty");
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException("SqlDialect cannot be null");
        }
        String quotes = SqlUtils.getSqlTypeQuotes(sqlDialect);
        if (sqlDialect == SqlDialect.SQLSERVER) {
            return "[" + identifier + "]";
        }
        return quotes + identifier + quotes;
    }

    public static <T, F> String extractQualifiedAlias(Fn<T, F> field, Map<String, String> aliasTableMap, String dataSourceName) {
        AbstractAliasHelper abstractAlias;
        String tableAlias = null;
        Fn<T, F> fn = field;
        if (field instanceof AbstractAliasHelper && (abstractAlias = (AbstractAliasHelper)field) instanceof AbstractAliasHelper.TableAliasImpl) {
            tableAlias = abstractAlias.getTableAlias();
            if (abstractAlias.getFnColumn() != null) {
                fn = abstractAlias.getFnColumn();
            } else {
                DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
                DbType dbType = dataSourceMeta.getDbType();
                SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
                tableAlias = StringUtils.isBlank(tableAlias) ? "" : SqlUtils.quoteIdentifier(sqlDialect, tableAlias);
                return tableAlias + "." + SqlUtils.quoteIdentifier(sqlDialect, abstractAlias.getColumnName());
            }
        }
        if (field instanceof GroupFn) {
            GroupFn groupFn = (GroupFn)field;
            tableAlias = groupFn.getTableAlias();
            if (groupFn.getFn() != null) {
                fn = groupFn.getFn();
            } else {
                DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
                DbType dbType = dataSourceMeta.getDbType();
                SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
                tableAlias = StringUtils.isBlank(tableAlias) ? "" : SqlUtils.quoteIdentifier(sqlDialect, tableAlias);
                return tableAlias + "." + SqlUtils.quoteIdentifier(sqlDialect, groupFn.getColumnName());
            }
        }
        String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
        if (tableAlias == null && aliasTableMap != null) {
            tableAlias = aliasTableMap.get(originalClassCanonicalName);
        }
        TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
        DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(tableMeta.getBindDataSourceName());
        DbType dbType = dataSourceMeta.getDbType();
        SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
        if (tableAlias == null) {
            tableAlias = tableMeta.getTableAlias();
        }
        ColumnMeta columnMeta = tableMeta.getColumnMeta(ReflectUtils.fnToFieldName(fn));
        String column = SqlUtils.quoteIdentifier(sqlDialect, columnMeta.getColumnName());
        return SqlUtils.quoteIdentifier(sqlDialect, tableAlias) + "." + column;
    }

    public static String extractQualifiedAliasOrderBy(OrderBy orderBy, Map<String, String> aliasTableMap, String dataSourceName) {
        DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
        DbType dbType = dataSourceMeta.getDbType();
        SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
        StringBuilder sqlBuilder = new StringBuilder(" ");
        if (orderBy instanceof CustomOrderBy) {
            CustomOrderBy customOrderBy = (CustomOrderBy)orderBy;
            sqlBuilder.append(customOrderBy.getOrderingFragment());
        }
        if (orderBy instanceof DefaultOrderBy) {
            DefaultOrderBy defaultOrderBy = (DefaultOrderBy)orderBy;
            if (defaultOrderBy.getTableAlias() != null) {
                sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, defaultOrderBy.getTableAlias())).append(".");
            }
            if (defaultOrderBy.getFieldFn() != null) {
                String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(defaultOrderBy.getFieldFn());
                TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
                ColumnMeta columnMeta = tableMeta.getColumnMeta(ReflectUtils.fnToFieldName(defaultOrderBy.getFieldFn()));
                if (defaultOrderBy.getTableAlias() == null && aliasTableMap != null) {
                    sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, tableMeta.getTableAlias())).append(".");
                }
                sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, columnMeta.getColumnName()));
            } else {
                sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, defaultOrderBy.getColumnName()));
            }
        }
        return sqlBuilder.toString();
    }

    public static Object formattedParameter(Object value) {
        return value;
    }

    public static String getSyntaxSelect(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "select";
            }
        }
        return "SELECT";
    }

    public static String getSyntaxAs(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "as";
            }
            case ORACLE: {
                return "";
            }
        }
        return "AS";
    }

    public static String getSyntaxFrom(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "from";
            }
        }
        return "FROM";
    }

    public static String getSyntaxJoin(SqlDialect sqlDialect, JoinTableType joinTableType) {
        if (joinTableType == JoinTableType.INNER) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "inner join";
                }
            }
            return "INNER JOIN";
        }
        if (joinTableType == JoinTableType.LEFT) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "left join";
                }
            }
            return "LEFT JOIN";
        }
        if (joinTableType == JoinTableType.RIGHT) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "right join";
                }
            }
            return "RIGHT JOIN";
        }
        if (joinTableType == JoinTableType.FULL) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    throw new UnsupportedOperationException("Unsupported associated table query full join type.");
                }
            }
            return "FULL OUTER JOIN";
        }
        if (joinTableType == JoinTableType.CROSS) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "cross join";
                }
            }
            return "CROSS JOIN";
        }
        throw new UnsupportedOperationException("Unsupported associated table query type.");
    }

    public static String getSyntaxOn(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "on";
            }
        }
        return "ON";
    }

    public static String getSyntaxWhere(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "where";
            }
        }
        return "WHERE";
    }

    public static String getSyntaxLimit(SqlDialect sqlDialect) {
        return "limit";
    }

    public static String getSyntaxExists(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "exists";
            }
        }
        return "EXISTS";
    }

    public static String getSyntaxGroupBy(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "group by";
            }
        }
        return "GROUP BY";
    }

    public static String getSyntaxHaving(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "having";
            }
        }
        return "HAVING";
    }

    public static String getSyntaxOrderBy(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "order by";
            }
        }
        return "ORDER BY";
    }

    public static String getSyntaxLogicalOperator(LogicalOperatorType logicalOperatorType, SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return logicalOperatorType.name().toLowerCase();
            }
        }
        return logicalOperatorType.name();
    }

    public static <T extends GenericWhereCondition> T matchDialectCondition(SqlDialect sqlDialect, Version version, Map<String, String> aliasTableMap, String dataSourceName) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return (T)new MysqlWhereCondition(version, aliasTableMap, dataSourceName);
            }
            case ORACLE: {
                return (T)new OracleWhereCondition(version, aliasTableMap, dataSourceName);
            }
        }
        return (T)new GenericWhereCondition(version, aliasTableMap, dataSourceName);
    }

    public static SqlDialect getSqlDialect(Class<?> fromTableClass) {
        TableMeta tableMeta = TableProvider.getTableMeta(fromTableClass);
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        return schemaProperties.getSqlDialect();
    }

    public static SqlSelectBuilder matchSqlSelectBuilder(SelectSpecification selectSpecification) {
        JoinTable joinTable = selectSpecification.getJoinTables().get(0);
        Enum sqlDialect = null;
        if (joinTable instanceof FromNestedJoin) {
            FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
            NestedJoin nestedJoin = fromNestedJoin.getNestedJoin();
            sqlDialect = SqlUtils.nestedJoinSqlDialect(nestedJoin);
        }
        if (joinTable instanceof NestedJoin) {
            NestedJoin nestedJoin = (NestedJoin)joinTable;
            sqlDialect = SqlUtils.nestedJoinSqlDialect(nestedJoin);
        }
        if (sqlDialect == null) {
            sqlDialect = SqlUtils.getSqlDialect(joinTable.getTableClass());
        }
        switch (1.$SwitchMap$com$dynamic$sql$enums$SqlDialect[sqlDialect.ordinal()]) {
            case 1: 
            case 2: {
                return new MysqlSqlSelectBuilder(selectSpecification);
            }
            case 3: {
                return new OracleSqlSelectBuilder(selectSpecification);
            }
        }
        return new GenericSqlSelectBuilder(selectSpecification);
    }

    public static SqlStatementSelectWrapper executeNestedSelect(Consumer<AbstractColumnReference> nestedSelectConsumer) {
        Select select = new Select();
        AbstractColumnReference columnReference = select.loadColumReference();
        nestedSelectConsumer.accept(columnReference);
        SqlSelectBuilder nestedSqlBuilder = SqlUtils.matchSqlSelectBuilder(select.getSelectSpecification());
        return nestedSqlBuilder.build();
    }

    private static SqlDialect nestedJoinSqlDialect(NestedJoin nestedJoin) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedJoin.getNestedSelect());
        nestedJoin.setSqlStatementWrapper(sqlStatementWrapper);
        return SchemaContextHolder.getSchemaProperties(sqlStatementWrapper.getDataSourceName()).getSqlDialect();
    }

    public static PreparedSql parsePreparedObject(SqlStatementWrapper sqlStatementWrapper) {
        SqlStatementWrapper.BatchType batchType = sqlStatementWrapper.getBatchType();
        if (batchType == null) {
            StringBuilder rawSql = sqlStatementWrapper.getRawSql();
            ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
            return SqlUtils.parsePreparedObject(rawSql, parameterBinder);
        }
        PreparedSql preparedSql = new PreparedSql(sqlStatementWrapper.getRawSql().toString());
        if (batchType == SqlStatementWrapper.BatchType.BATCH) {
            List<ParameterBinder> batchParameterBinders = sqlStatementWrapper.getBatchParameterBinders();
            for (ParameterBinder batchParameterBinder : batchParameterBinders) {
                List<Object> param = batchParameterBinder.getValues().stream().map(SqlUtils::formattedParameter).collect(Collectors.toList());
                preparedSql.addBatchParams(param);
            }
            return preparedSql;
        }
        List<ParameterBinder> batchParameterBinders = sqlStatementWrapper.getBatchParameterBinders();
        ArrayList<Object> params = new ArrayList<Object>();
        for (ParameterBinder batchParameterBinder : batchParameterBinders) {
            List param = batchParameterBinder.getValues().stream().map(SqlUtils::formattedParameter).collect(Collectors.toList());
            params.addAll(param);
        }
        preparedSql.addBatchParams(params);
        return preparedSql;
    }

    public static PreparedSql parsePreparedObject(StringBuilder rawSql, ParameterBinder parameterBinder) {
        StringBuilder modifiedSql = new StringBuilder(rawSql);
        Pattern uuidPattern = Pattern.compile(":[0-9a-f]{32}");
        Matcher matcher = uuidPattern.matcher(rawSql);
        ArrayList<Object> params = new ArrayList<Object>();
        while (matcher.find()) {
            String placeholder = matcher.group();
            if (!parameterBinder.contains(placeholder)) continue;
            int start = matcher.start();
            int end = matcher.end();
            Object formattedParameter = SqlUtils.formattedParameter(parameterBinder.getValue(placeholder));
            if (formattedParameter instanceof AnonymousFunction) {
                AnonymousFunction anonymousFunction = (AnonymousFunction)formattedParameter;
                PreparedSql functionPreparedSql = SqlUtils.parsePreparedObject(new StringBuilder(anonymousFunction.getFunctionToString()), anonymousFunction.getParameterBinder());
                params.addAll(functionPreparedSql.getParams());
                modifiedSql.replace(start, end, functionPreparedSql.getSql());
            } else {
                params.add(formattedParameter);
                modifiedSql.replace(start, end, "?");
            }
            matcher = uuidPattern.matcher(modifiedSql);
        }
        return new PreparedSql(modifiedSql.toString(), params);
    }

    public static String registerValueWithKey(ParameterBinder parameters, Object value) {
        return SqlUtils.registerValueWithKey(parameters, null, value);
    }

    public static String registerValueWithKey(ParameterBinder parameters, Fn<?, ?> fn, Object value) {
        String key = SqlUtils.generateBindingKey();
        if (fn == null) {
            parameters.add(key, value);
            return key;
        }
        if (fn instanceof AbstractAliasHelper) {
            parameters.add(key, value);
            return key;
        }
        String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
        String fieldName = ReflectUtils.fnToFieldName(fn);
        TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
        ColumnMeta columnMeta = tableMeta.getColumnMeta(fieldName);
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        parameters.add(key, ConverterUtils.convertToDatabaseColumn(schemaProperties.getSqlDialect(), columnMeta, value));
        return key;
    }

    public static String generateBindingKey() {
        return ":" + UUID.randomUUID().toString().replace("-", "");
    }

    public static void close(Connection connection, ResultSet resultSet, Statement statement) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("Connection closed abnormally.", (Throwable)e);
            }
        }
        SqlUtils.close(resultSet, statement);
    }

    public static void close(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error("ResultSet closed abnormally.", (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.error("Statement closed abnormally.", (Throwable)e);
            }
        }
    }
}

