/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.utils.CollectionUtils;
import java.util.Collection;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isNotEquals(String str1, String str2) {
        return !StringUtils.isEquals(str1, str2);
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean isNotEqualsIgnoreCase(String str1, String str2) {
        return !StringUtils.isEqualsIgnoreCase(str1, str2);
    }

    public static String join(CharSequence delimiter, Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        return StringUtils.join(delimiter, collection.toArray());
    }

    public static String join(CharSequence delimiter, Object ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) {
                result.append("null");
            } else {
                result.append(param);
            }
            if (i >= params.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }
}

