/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.context.properties;

import com.dynamic.sql.core.Version;
import com.dynamic.sql.enums.DbType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.utils.SqlUtils;

public class SchemaProperties {
    private String dataSourceName;
    private SqlDialect sqlDialect;
    private String[] bindBasePackages;
    private boolean enableCompatibilityMode;
    private boolean isGlobalDefault = false;
    private boolean useSchemaInQuery = false;
    private boolean useAsInQuery = true;
    private String databaseProductVersion;
    private PrintSqlProperties printSqlProperties = new PrintSqlProperties();
    private int majorVersionNumber;
    private int minorVersionNumber;
    private int patchVersionNumber;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public boolean isEnableCompatibilityMode() {
        return this.enableCompatibilityMode;
    }

    public void setEnableCompatibilityMode(boolean enableCompatibilityMode) {
        this.enableCompatibilityMode = enableCompatibilityMode;
    }

    public boolean isUseSchemaInQuery() {
        return this.useSchemaInQuery;
    }

    public void setUseSchemaInQuery(boolean useSchemaInQuery) {
        this.useSchemaInQuery = useSchemaInQuery;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(DbType dbType, String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
        Version version = SqlUtils.databaseProductVersion(dbType, databaseProductVersion);
        this.majorVersionNumber = version.getMajorVersion();
        this.minorVersionNumber = version.getMinorVersion();
        this.patchVersionNumber = version.getPatchVersion();
    }

    public boolean isUseAsInQuery() {
        return this.useAsInQuery;
    }

    public void setUseAsInQuery(boolean useAsInQuery) {
        this.useAsInQuery = useAsInQuery;
    }

    public PrintSqlProperties getPrintSqlProperties() {
        return this.printSqlProperties;
    }

    public void setPrintSqlProperties(PrintSqlProperties printSqlProperties) {
        this.printSqlProperties = printSqlProperties;
    }

    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public int getPatchVersionNumber() {
        return this.patchVersionNumber;
    }

    public boolean isGlobalDefault() {
        return this.isGlobalDefault;
    }

    public void setGlobalDefault(boolean globalDefault) {
        this.isGlobalDefault = globalDefault;
    }

    public String[] getBindBasePackages() {
        return this.bindBasePackages;
    }

    public void setBindBasePackages(String ... bindBasePackages) {
        this.bindBasePackages = bindBasePackages;
    }

    public static class PrintSqlProperties {
        private boolean printSql = true;
        private boolean printDataSourceName = true;

        public boolean isPrintSql() {
            return this.printSql;
        }

        public void setPrintSql(boolean printSql) {
            this.printSql = printSql;
        }

        public boolean isPrintDataSourceName() {
            return this.printDataSourceName;
        }

        public void setPrintDataSourceName(boolean printDataSourceName) {
            this.printDataSourceName = printDataSourceName;
        }
    }
}

