/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.json;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.exception.FunctionException;
import com.dynamic.sql.model.TableAliasMapping;
import java.util.Map;

public class JsonExtract
extends ColumnFunctionDecorator
implements TableFunction {
    private String jsonPath;

    public JsonExtract(AbstractColumFunction delegateFunction, String jsonPath) {
        super(delegateFunction);
        this.jsonPath = jsonPath;
    }

    public <T, F> JsonExtract(FieldFn<T, F> fn, String jsonPath) {
        super(fn);
        this.jsonPath = jsonPath;
    }

    @Override
    public String getFunctionToString(SqlDialect sqlDialect, Version version, Map<String, TableAliasMapping> aliasTableMap) {
        if (sqlDialect == SqlDialect.ORACLE) {
            return "JSON_VALUE(" + this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap) + ", " + this.jsonPath + ")";
        }
        if (sqlDialect == SqlDialect.MYSQL) {
            if (version.getMajorVersion() < 5 && version.getMinorVersion() < 7) {
                throw FunctionException.unsupportedFunctionException("json_extract", version, sqlDialect);
            }
            return "json_extract(" + this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap) + ", " + this.jsonPath + ")";
        }
        throw FunctionException.unsupportedFunctionException("json_extract", sqlDialect);
    }
}

