/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.modifiers;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.ColumnModifiers;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.exception.FunctionException;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.StringUtils;
import java.util.Map;

public class Distinct
extends ColumnFunctionDecorator
implements ColumnModifiers {
    Boolean shouldAppendDelimiter = null;

    public Distinct(AbstractColumFunction delegateFunction) {
        super(delegateFunction);
    }

    public <T, F> Distinct(FieldFn<T, F> fn) {
        super(fn);
    }

    public <T, F> Distinct(String tableAlias, FieldFn<T, F> fn) {
        super(tableAlias, fn);
    }

    public Distinct() {
    }

    @Override
    public String getFunctionToString(SqlDialect sqlDialect, Version version, Map<String, TableAliasMapping> aliasTableMap) throws UnsupportedOperationException {
        String functionToString = this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap);
        this.shouldAppendDelimiter = !StringUtils.isBlank(functionToString);
        if (this.shouldAppendDelimiter.booleanValue()) {
            if (sqlDialect == SqlDialect.ORACLE) {
                return "DISTINCT(" + this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap) + ")".concat(this.appendArithmeticSql(sqlDialect, version));
            }
            if (sqlDialect == SqlDialect.MYSQL) {
                return "distinct(" + this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap) + ")".concat(this.appendArithmeticSql(sqlDialect, version));
            }
        } else {
            if (sqlDialect == SqlDialect.ORACLE) {
                return "DISTINCT";
            }
            if (sqlDialect == SqlDialect.MYSQL) {
                return "distinct";
            }
        }
        throw FunctionException.unsupportedFunctionException("distinct", sqlDialect);
    }

    @Override
    public boolean shouldAppendDelimiter() {
        if (this.shouldAppendDelimiter == null) {
            throw new IllegalStateException("You need to call the getFunctionToString function first");
        }
        return this.shouldAppendDelimiter;
    }
}

