/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.windows;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.dml.select.order.DefaultOrderBy;
import com.dynamic.sql.core.dml.select.order.NullsFirst;
import com.dynamic.sql.core.dml.select.order.NullsLast;
import com.dynamic.sql.core.dml.select.order.OrderBy;
import com.dynamic.sql.enums.SortOrder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.exception.FunctionException;
import java.util.ArrayList;
import java.util.List;

public class Over {
    private List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private String overClause;

    public <T, F> Over orderBy(FieldFn<T, F> fn) {
        return this.orderBy(fn, SortOrder.ASC);
    }

    public Over orderBy(String tableAlias, String column) {
        return this.orderBy(tableAlias, column, SortOrder.ASC);
    }

    public <T, F> Over orderBy(FieldFn<T, F> fn, SortOrder sortOrder) {
        DefaultOrderBy defaultOrderBy = new DefaultOrderBy(fn, sortOrder);
        this.orderByList.add(defaultOrderBy);
        return this;
    }

    public Over orderBy(ColumFunction columFunction, SortOrder sortOrder) {
        DefaultOrderBy defaultOrderBy = new DefaultOrderBy(columFunction, sortOrder);
        this.orderByList.add(defaultOrderBy);
        return this;
    }

    public Over orderBy(String tableAlias, String column, SortOrder sortOrder) {
        DefaultOrderBy defaultOrderBy = new DefaultOrderBy(tableAlias, column, sortOrder);
        this.orderByList.add(defaultOrderBy);
        return this;
    }

    public Over nullsLast() {
        this.orderByList.add(new NullsLast());
        return this;
    }

    public Over nullsFirst() {
        this.orderByList.add(new NullsFirst());
        return this;
    }

    public List<OrderBy> getOrderByList() {
        return this.orderByList;
    }

    public void setOverClause(String overClause) {
        this.overClause = overClause;
    }

    public String toOverString(SqlDialect sqlDialect) {
        if (sqlDialect == SqlDialect.MYSQL) {
            return "over(" + this.overClause + ")";
        }
        throw FunctionException.unsupportedFunctionException("over", sqlDialect);
    }
}

