/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.dml.select.AbstractFetchResult;
import com.dynamic.sql.core.dml.select.CollectionColumnMapping;
import com.dynamic.sql.plugins.conversion.AttributeConverter;
import com.dynamic.sql.plugins.conversion.FetchResultConverter;
import com.dynamic.sql.table.FieldMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.table.TableUtils;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FetchResultImpl<R>
extends AbstractFetchResult<R> {
    private final Class<R> resultClass;
    private final CollectionColumnMapping collectionColumnMapping;

    public FetchResultImpl(Class<R> returnClass, List<Map<String, Object>> wrapperList, CollectionColumnMapping collectionColumnMapping) {
        super(wrapperList);
        this.resultClass = returnClass;
        this.collectionColumnMapping = collectionColumnMapping;
    }

    @Override
    public R toOne() {
        Collection<R> rs = this.convertToCollection(ArrayList::new);
        if (rs.isEmpty()) {
            return null;
        }
        if (rs.size() > 1) {
            throw new IllegalStateException("Expected one result, but found: " + rs.size());
        }
        return rs.iterator().next();
    }

    @Override
    public <L extends List<R>> L toList(Supplier<L> listSupplier) {
        return (L)((List)this.convertToCollection(listSupplier));
    }

    @Override
    public <S extends Set<R>> S toSet(Supplier<S> setSupplier) {
        return (S)((Set)this.convertToCollection(setSupplier));
    }

    @Override
    public <K, V, M extends Map<K, V>> Map<K, V> toMap(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return this.convertToMap(keyMapper, valueMapper, mergeFunction, mapSupplier);
    }

    @Override
    public <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> toGroupingBy(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, Supplier<C> collectionSupplier, Supplier<M> mapSupplier) {
        return this.convertToGroupingBy(keyMapper, valueMapper, collectionSupplier, mapSupplier);
    }

    private Collection<R> convertToCollection(Supplier<? extends Collection<R>> listSupplier) {
        Collection<R> collection = listSupplier.get();
        if (CollectionUtils.isEmpty(this.wrapperList)) {
            return collection;
        }
        FetchResultConverter<R> fetchResultConverter = ConverterUtils.getFetchResultConverter(this.resultClass);
        if (fetchResultConverter != null) {
            for (Map stringObjectMap : this.wrapperList) {
                collection.add(fetchResultConverter.convertValueTo(stringObjectMap));
            }
            return collection;
        }
        if (this.resultClass == Object.class || Map.class.isAssignableFrom(this.resultClass) || Collection.class.isAssignableFrom(this.resultClass)) {
            return this.wrapperList;
        }
        if (this.resultClass.getClassLoader() == null || this.resultClass.isEnum()) {
            return this.convertToSystemClass(collection);
        }
        if (AttributeConverter.class.isAssignableFrom(this.resultClass)) {
            AttributeConverter customAttributeConverter = ConverterUtils.getOrSetCustomAttributeConverter(this.resultClass);
            for (Map stringObjectMap : this.wrapperList) {
                Object next = stringObjectMap.values().iterator().next();
                if (customAttributeConverter.isSkipConvertToEntityAttribute(next)) continue;
                collection.add(customAttributeConverter.convertToEntityAttribute(next));
            }
            return collection;
        }
        List<FieldMeta> fieldMetas = this.getFieldMetas("Collection");
        Map<String, FieldMeta> columnNameMap = fieldMetas.stream().collect(Collectors.toMap(FieldMeta::getColumnName, v -> v));
        Map<String, FieldMeta> fieldNameMap = fieldMetas.stream().collect(Collectors.toMap(k -> k.getField().getName(), v -> v));
        if (this.collectionColumnMapping == null) {
            for (Map columnObjectMap : this.wrapperList) {
                collection.add(this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap));
            }
            return collection;
        }
        System.out.println(this.collectionColumnMapping);
        String targetProperty = this.collectionColumnMapping.getTargetProperty();
        FieldMeta targetFieldMeta = this.resolveFieldMeta(targetProperty, fieldNameMap, columnNameMap);
        if (targetFieldMeta == null) {
            throw new IllegalArgumentException("Index column [" + targetProperty + "] does not exist");
        }
        Field targetField = targetFieldMeta.getField();
        Class<?> childElementClass = ReflectUtils.getUserGenericClassByField(targetField);
        List collectionColumnMetas = TableUtils.parseViewClass(childElementClass).getViewColumnMetas();
        Map<String, FieldMeta> childColumnNameMap = collectionColumnMetas.stream().collect(Collectors.toMap(FieldMeta::getColumnName, v -> v));
        Map<String, FieldMeta> childFieldNameMap = collectionColumnMetas.stream().collect(Collectors.toMap(k -> k.getField().getName(), v -> v));
        HashMap<Object, Collection> childHashMap = new HashMap<Object, Collection>();
        HashMap<Object, R> parentHashMap = new HashMap<Object, R>();
        FieldFn<?, ?> parentKey = this.collectionColumnMapping.getParentKey();
        String parentColumn = ReflectUtils.fnToFieldName(parentKey);
        FieldMeta parentFieldMeta = this.resolveFieldMeta(parentColumn, fieldNameMap, columnNameMap);
        for (Map columnObjectMap : this.wrapperList) {
            Object child;
            Object r = this.reflectionInstance(childHashMap.keySet(), parentFieldMeta, columnObjectMap, columnNameMap, fieldNameMap);
            Object parentValue = ReflectUtils.getFieldValue(r, parentFieldMeta.getField());
            if (!parentHashMap.containsKey(parentValue)) {
                parentHashMap.put(parentValue, r);
            } else {
                r = parentHashMap.get(parentValue);
            }
            if ((child = this.childReflectionInstance(childElementClass, columnObjectMap, childColumnNameMap, childFieldNameMap)) == null) continue;
            Collection childCollection = childHashMap.computeIfAbsent(parentValue, key -> Set.class.isAssignableFrom(targetField.getType()) ? new LinkedHashSet() : new ArrayList());
            childCollection.add(child);
            ReflectUtils.setFieldValue(r, targetField, childCollection);
        }
        collection.addAll(parentHashMap.values());
        return collection;
    }

    private FieldMeta resolveFieldMeta(String name, Map<String, FieldMeta> fieldNameMap, Map<String, FieldMeta> columnNameMap) {
        FieldMeta meta = fieldNameMap.get(name);
        return meta != null ? meta : columnNameMap.get(name);
    }

    private <T, K, V, M extends Map<K, V>> Map<K, V> convertToMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return this.convertTo(mapSupplier, (m, columnObjectMap, columnNameMap, fieldNameMap) -> {
            R value = this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap);
            Object key = keyMapper.apply(value);
            Object val = valueMapper.apply(value);
            if (val == null) {
                m.put(key, val);
            } else {
                m.merge(key, val, mergeFunction);
            }
        });
    }

    public <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> convertToGroupingBy(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, Supplier<C> collectionSupplier, Supplier<M> mapSupplier) {
        return this.convertTo(mapSupplier, (m, columnObjectMap, columnNameMap, fieldNameMap) -> {
            R result = this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap);
            Object key = keyMapper.apply(result);
            Object value = valueMapper.apply(result);
            Collection groupedCollection = (Collection)m.computeIfAbsent(key, arg_0 -> FetchResultImpl.lambda$null$8((Supplier)collectionSupplier, arg_0));
            groupedCollection.add(value);
        });
    }

    private Collection<R> convertToSystemClass(Collection<R> collection) {
        for (Map stringObjectMap : this.wrapperList) {
            if (stringObjectMap.size() > 1) {
                throw new IllegalStateException("Expecting to return one column of results, but querying multiple columns: " + StringUtils.join((CharSequence)", ", stringObjectMap.keySet()));
            }
            if (stringObjectMap.isEmpty()) {
                collection.add(null);
            }
            Map.Entry entry = stringObjectMap.entrySet().iterator().next();
            R value = ConverterUtils.convertToEntityAttribute(null, this.resultClass, entry.getValue());
            collection.add(value);
        }
        return collection;
    }

    private FieldMeta getColumnMeta(String columnName, Map<String, FieldMeta> columnNameMap, Map<String, FieldMeta> fieldNameMap) {
        FieldMeta columnMeta = columnNameMap.get(columnName);
        if (columnMeta == null) {
            columnMeta = fieldNameMap.get(columnName);
        }
        return columnMeta;
    }

    R reflectionInstance(Map<String, Object> columnObjectMap, Map<String, FieldMeta> columnNameMap, Map<String, FieldMeta> fieldNameMap) {
        return this.reflectionInstance(null, null, columnObjectMap, columnNameMap, fieldNameMap);
    }

    R reflectionInstance(Set<Object> objects, FieldMeta parentFieldMeta, Map<String, Object> columnObjectMap, Map<String, FieldMeta> columnNameMap, Map<String, FieldMeta> fieldNameMap) {
        R instance = ReflectUtils.instance(this.resultClass, new Object[0]);
        if (objects != null && parentFieldMeta != null) {
            String parentColumnName = parentFieldMeta.getColumnName();
            Object columnValue2 = columnObjectMap.get(parentColumnName);
            FieldMeta columnMeta = this.getColumnMeta(parentColumnName, columnNameMap, fieldNameMap);
            if (columnMeta != null) {
                Object value = ConverterUtils.convertToEntityAttribute(columnMeta, columnMeta.getField().getType(), columnValue2);
                if (value != null) {
                    ReflectUtils.setFieldValue(instance, columnMeta.getField(), value);
                }
                if (objects.contains(value)) {
                    return instance;
                }
            }
        }
        columnObjectMap.forEach((columnName, columnValue) -> {
            FieldMeta columnMeta = this.getColumnMeta((String)columnName, columnNameMap, fieldNameMap);
            if (columnMeta == null) {
                return;
            }
            Object value = ConverterUtils.convertToEntityAttribute(columnMeta, columnMeta.getField().getType(), columnValue);
            if (value != null) {
                ReflectUtils.setFieldValue(instance, columnMeta.getField(), value);
            }
        });
        return instance;
    }

    Object childReflectionInstance(Class<?> childElementClass, Map<String, Object> columnObjectMap, Map<String, FieldMeta> childColumnNameMap, Map<String, FieldMeta> childFieldNameMap) {
        Object childInstance = ReflectUtils.instance(childElementClass, new Object[0]);
        AtomicBoolean isReturnNull = new AtomicBoolean(true);
        columnObjectMap.forEach((columnName, columnValue) -> {
            Object value;
            FieldMeta childColumnMeta = this.getColumnMeta((String)columnName, childColumnNameMap, childFieldNameMap);
            if (childColumnMeta != null && (value = ConverterUtils.convertToEntityAttribute(childColumnMeta, childColumnMeta.getField().getType(), columnValue)) != null) {
                isReturnNull.set(false);
                ReflectUtils.setFieldValue(childInstance, childColumnMeta.getField(), value);
            }
        });
        return isReturnNull.get() ? null : childInstance;
    }

    private <K, V, M extends Map<K, V>> Map<K, V> convertTo(Supplier<M> mapSupplier, Operator operator) {
        Map m = (Map)mapSupplier.get();
        if (CollectionUtils.isEmpty(this.wrapperList)) {
            return m;
        }
        List<FieldMeta> fieldMetas = this.getFieldMetas("Map");
        Map<String, FieldMeta> columnNameMap = fieldMetas.stream().collect(Collectors.toMap(FieldMeta::getColumnName, v -> v));
        Map<String, FieldMeta> fieldNameMap = fieldMetas.stream().collect(Collectors.toMap(k -> k.getField().getName(), v -> v));
        for (Map columnObjectMap : this.wrapperList) {
            operator.apply(m, columnObjectMap, columnNameMap, fieldNameMap);
        }
        return m;
    }

    private List<FieldMeta> getFieldMetas(String converterTips) {
        List<FieldMeta> fieldMetas;
        TableMeta tableMeta = TableProvider.getTableMeta(this.resultClass);
        if (tableMeta == null) {
            if (this.resultClass.getClassLoader() == null) {
                throw new IllegalStateException(this.resultClass.getCanonicalName() + " cannot be mapped to " + converterTips);
            }
            fieldMetas = TableUtils.parseViewClass(this.resultClass).getViewColumnMetas();
        } else {
            fieldMetas = tableMeta.getColumnMetas();
        }
        return fieldMetas;
    }

    private static /* synthetic */ Object lambda$null$8(Supplier collectionSupplier, Object k) {
        return (Collection)collectionSupplier.get();
    }

    static interface Operator {
        public void apply(Map var1, Map<String, Object> var2, Map<String, FieldMeta> var3, Map<String, FieldMeta> var4);
    }
}

