/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.interceptor;

import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.interceptor.ExecutionControl;
import com.dynamic.sql.interceptor.SqlInterceptor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInterceptorChain
implements SqlInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlInterceptorChain.class);
    private List<SqlInterceptor> interceptors = new ArrayList<SqlInterceptor>();

    private SqlInterceptorChain() {
    }

    public static SqlInterceptorChain getInstance() {
        return Holder.INSTANCE;
    }

    public void addInterceptor(SqlInterceptor interceptor) {
        if (this.interceptors.contains(interceptor)) {
            return;
        }
        this.interceptors.add(interceptor);
        this.interceptors.sort(Comparator.comparingInt(SqlInterceptor::getOrder));
    }

    @Override
    public ExecutionControl beforeExecution(SqlStatementWrapper sqlStatementWrapper, Connection connection) {
        for (SqlInterceptor interceptor : this.interceptors) {
            ExecutionControl executionControl = interceptor.beforeExecution(sqlStatementWrapper, connection);
            if (executionControl != ExecutionControl.SKIP) continue;
            log.trace("The SQL interceptor link interrupts execution, located at: {}", (Object)interceptor.getClass().getSimpleName());
            return executionControl;
        }
        return ExecutionControl.PROCEED;
    }

    @Override
    public <R> R retrieveSkippedResult(SqlStatementWrapper sqlStatementWrapper, Connection connection) {
        for (SqlInterceptor interceptor : this.interceptors) {
            Object skippedResult = interceptor.retrieveSkippedResult(sqlStatementWrapper, connection);
            if (skippedResult == null) continue;
            log.trace("The SQL interceptor link interrupts execution, located at: {}", (Object)interceptor.getClass().getSimpleName());
            return skippedResult;
        }
        return null;
    }

    @Override
    public void afterExecution(PreparedSql preparedSql, Object applyResult, Exception exception) {
        for (SqlInterceptor interceptor : this.interceptors) {
            interceptor.afterExecution(preparedSql, applyResult, exception);
        }
    }

    public SqlInterceptor getInterceptor(Class<? extends SqlInterceptor> sqlInterceptorClass) {
        if (sqlInterceptorClass == null) {
            return null;
        }
        for (SqlInterceptor interceptor : this.interceptors) {
            if (!interceptor.getClass().equals(sqlInterceptorClass)) continue;
            return interceptor;
        }
        return null;
    }

    private static class Holder {
        private static final SqlInterceptorChain INSTANCE = new SqlInterceptorChain();

        private Holder() {
        }
    }
}

