/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPage {
    protected static final Logger log = LoggerFactory.getLogger(AbstractPage.class);
    protected int pageIndex;
    protected final int pageSize;
    protected Long total;
    protected int totalPage;
    protected String pagePluginTypeName;

    protected AbstractPage(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.pagePluginTypeName = "DYNAMIC_SQL2";
    }

    protected AbstractPage(int pageIndex, int pageSize, String pagePluginTypeName) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.pagePluginTypeName = pagePluginTypeName;
    }

    public final int getPageIndex() {
        return this.pageIndex;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    abstract void setRecords(Supplier<?> var1);

    abstract int getRealSize();

    public final boolean hasPreviousPage() {
        return this.getPageIndex() > 1;
    }

    public final boolean hasNextPage() {
        if (this.getPageIndex() < this.totalPage) {
            if (this.getRealSize() > 0) {
                return true;
            }
            log.warn("Expected to return data, but the current page data is empty.");
        }
        return false;
    }

    public long getTotal() {
        if (this.total == null) {
            return 0L;
        }
        return this.total;
    }

    public final int getTotalPage() {
        return this.totalPage;
    }

    protected void setTotal(long total) {
        this.total = total;
    }

    protected void initTotalPage() {
        long pages = (this.total + (long)this.pageSize - 1L) / (long)this.pageSize;
        this.totalPage = (int)pages;
    }

    protected Long getCacheTotal() {
        return this.total;
    }
}

