/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination.impl;

import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.ConditionPageInfo;
import com.dynamic.sql.plugins.pagination.DialectPagination;
import com.dynamic.sql.utils.SqlUtils;
import java.util.HashMap;

public class MySQLDialectPagination
implements DialectPagination {
    @Override
    public StringBuilder selectCountSql(Version version, SqlStatementWrapper sqlStatementWrapper, AbstractPage abstractPage) {
        StringBuilder selectCountSql = new StringBuilder();
        selectCountSql.append("select count(1) from (");
        if (abstractPage instanceof ConditionPageInfo) {
            ConditionPageInfo conditionPageInfo = (ConditionPageInfo)abstractPage;
            StringBuilder selectCountAppendWhereSql = new StringBuilder(sqlStatementWrapper.getRawSql());
            selectCountAppendWhereSql.insert(0, "select * from (");
            selectCountAppendWhereSql.append(") _append_count_page_temp ");
            HashMap<String, TableAliasMapping> aliasMap = new HashMap<String, TableAliasMapping>();
            aliasMap.put("**", new TableAliasMapping("_append_count_page_temp", true));
            Object whereCondition = SqlUtils.matchDialectCondition(SqlDialect.MYSQL, version, aliasMap, sqlStatementWrapper.getDataSourceName());
            conditionPageInfo.getAppendWhere().accept((WhereCondition)whereCondition);
            String whereConditionSyntax = ((GenericWhereCondition)whereCondition).getWhereConditionSyntax();
            selectCountAppendWhereSql.append(" where ").append(whereConditionSyntax);
            ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
            sqlStatementWrapper.getParameterBinder().addParameterBinder(whereParameterBinder);
            selectCountSql.append((CharSequence)selectCountAppendWhereSql);
        } else {
            selectCountSql.append((CharSequence)sqlStatementWrapper.getRawSql());
        }
        selectCountSql.append(") _count_page_temp ");
        return selectCountSql;
    }

    @Override
    public void modifyPagingSql(Version version, SqlStatementWrapper sqlStatementWrapper, AbstractPage abstractPage) {
        StringBuilder selectPageSql = sqlStatementWrapper.getRawSql();
        selectPageSql.insert(0, "select * from (");
        selectPageSql.append(") _page_temp ");
        ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
        if (abstractPage instanceof ConditionPageInfo) {
            ConditionPageInfo conditionPageInfo = (ConditionPageInfo)abstractPage;
            HashMap<String, TableAliasMapping> aliasMap = new HashMap<String, TableAliasMapping>();
            aliasMap.put("**", new TableAliasMapping("_page_temp", true));
            Object whereCondition = SqlUtils.matchDialectCondition(SqlDialect.MYSQL, version, aliasMap, sqlStatementWrapper.getDataSourceName());
            conditionPageInfo.getAppendWhere().accept((WhereCondition)whereCondition);
            String whereConditionSyntax = ((GenericWhereCondition)whereCondition).getWhereConditionSyntax();
            selectPageSql.append(" where ").append(whereConditionSyntax);
            ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
            parameterBinder.addParameterBinder(whereParameterBinder);
        }
        int offset = (abstractPage.getPageIndex() - 1) * abstractPage.getPageSize();
        String offsetKey = SqlUtils.registerValueWithKey(parameterBinder, offset);
        String pageSizeKey = SqlUtils.registerValueWithKey(parameterBinder, abstractPage.getPageSize());
        selectPageSql.append(" limit ");
        selectPageSql.append(offsetKey);
        selectPageSql.append(", ");
        selectPageSql.append(pageSizeKey);
    }
}

