/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.table;

import com.dynamic.sql.anno.CTETable;
import com.dynamic.sql.anno.Column;
import com.dynamic.sql.anno.Table;
import com.dynamic.sql.anno.View;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.table.TableEntityMapping;
import com.dynamic.sql.table.TableUtils;
import com.dynamic.sql.table.cte.CTEEntityMapping;
import com.dynamic.sql.table.view.ViewColumnMeta;
import com.dynamic.sql.table.view.ViewMeta;
import com.dynamic.sql.utils.NamingUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStructureScanner {
    private static final Logger log = LoggerFactory.getLogger(SchemaStructureScanner.class);

    private SchemaStructureScanner() {
    }

    public static List<TableEntityMapping> findTableEntities(String forPackage) {
        log.debug("Find the table entities based on the provided '{}' path. ", (Object)forPackage);
        Reflections reflections = SchemaStructureScanner.getReflections(forPackage);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(Table.class);
        ArrayList<TableEntityMapping> tableEntityMappings = new ArrayList<TableEntityMapping>();
        try {
            for (Class annotatedClass : annotatedClasses) {
                tableEntityMappings.add(SchemaStructureScanner.parseTableEntityMapping(annotatedClass));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An exception occurred while retrieving entities.", e);
        }
        return tableEntityMappings;
    }

    public static List<CTEEntityMapping> findCTEEntities(String forPackage) {
        Reflections reflections = SchemaStructureScanner.getReflections(forPackage);
        return reflections.getTypesAnnotatedWith(CTETable.class).stream().map(cte -> {
            CTETable cteTable = cte.getDeclaredAnnotation(CTETable.class);
            CTEEntityMapping cteEntityMapping = new CTEEntityMapping();
            cteEntityMapping.setCteName(cteTable.value());
            cteEntityMapping.setCache(cteTable.isCache());
            cteEntityMapping.setCteClass((Class<?>)cte);
            return cteEntityMapping;
        }).collect(Collectors.toList());
    }

    public static Map<Class<?>, ViewMeta> findViewEntities(String forPackage) {
        Reflections reflections = SchemaStructureScanner.getReflections(forPackage);
        HashMap viewMap = new HashMap();
        reflections.getTypesAnnotatedWith(View.class).forEach(cls -> {
            ViewMeta viewMeta = new ViewMeta();
            List<Field> allFields = ReflectUtils.getAllFields(cls, TableUtils.filterFieldTypeRules());
            List<ViewColumnMeta> viewColumnMetas = allFields.stream().map(field -> {
                Column column = field.getDeclaredAnnotation(Column.class);
                String columnValue = column != null ? column.value() : null;
                String columnName = NamingUtils.camelToSnakeCase(StringUtils.isBlank(columnValue) ? field.getName() : columnValue);
                ViewColumnMeta viewColumnMeta = new ViewColumnMeta();
                viewColumnMeta.setColumnName(columnName);
                viewColumnMeta.setField((Field)field);
                return viewColumnMeta;
            }).collect(Collectors.toList());
            viewMeta.setViewColumnMetas(viewColumnMetas);
            viewMap.put((Class<?>)cls, viewMeta);
        });
        return viewMap;
    }

    private static Reflections getReflections(String forPackage) {
        return new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)forPackage, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(forPackage)).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
    }

    public static String matchBestDataSourceName(Class<?> annotatedClass, String inLineDataSourceName) {
        if (StringUtils.isNotBlank(inLineDataSourceName)) {
            if (!DataSourceProvider.existDataSource(inLineDataSourceName)) {
                throw new IllegalArgumentException("DataSource '" + inLineDataSourceName + "' does not exist. Please check that the data source has been initialized correctly");
            }
            return inLineDataSourceName;
        }
        Map<String, String[]> bindPath = DataSourceProvider.getDataSourceBoundPath();
        if (bindPath.isEmpty()) {
            throw new NoSuchElementException("No data source has been initialized");
        }
        String thisTablePath = annotatedClass.getCanonicalName();
        HashMap bestMatchMap = new HashMap();
        bindPath.forEach((datasourceName, pathPrefix) -> {
            if (pathPrefix == null || ((String[])pathPrefix).length == 0) {
                return;
            }
            String bestMatch = SchemaStructureScanner.getBestMatch(thisTablePath, pathPrefix);
            if (bestMatch != null) {
                bestMatchMap.put(bestMatch, datasourceName);
            }
        });
        if (!bestMatchMap.isEmpty()) {
            String bestMatch = SchemaStructureScanner.getBestMatch(thisTablePath, bestMatchMap.keySet().toArray(new String[0]));
            return (String)bestMatchMap.get(bestMatch);
        }
        String defaultDataSourceName = DataSourceProvider.getDefaultDataSourceName();
        if (StringUtils.isNotBlank(defaultDataSourceName)) {
            return defaultDataSourceName;
        }
        throw new NoSuchElementException("Table class '" + annotatedClass.getCanonicalName() + "' cannot be matched to any data source");
    }

    public static String getBestMatch(String classPath, String[] paths) {
        String bestMatch = null;
        int maxDepth = -1;
        int maxLength = -1;
        for (String path : paths) {
            if (!classPath.startsWith(path)) continue;
            int depth = path.split("\\.").length;
            int length = path.length();
            if (depth <= maxDepth && (depth != maxDepth || length <= maxLength)) continue;
            maxDepth = depth;
            maxLength = length;
            bestMatch = path;
        }
        return bestMatch;
    }

    public static TableEntityMapping parseTableEntityMapping(Class<?> annotatedClass) {
        Table table = annotatedClass.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        TableEntityMapping tableEntityMapping = new TableEntityMapping();
        tableEntityMapping.setTableName(table.value().trim());
        String tableAlias = table.alias().trim();
        if (StringUtils.isBlank(tableAlias)) {
            tableAlias = tableEntityMapping.getTableName();
        }
        tableEntityMapping.setTableAlias(tableAlias);
        tableEntityMapping.setEntityClass(annotatedClass);
        tableEntityMapping.setCache(table.isCache());
        tableEntityMapping.setBindDataSourceName(SchemaStructureScanner.matchBestDataSourceName(annotatedClass, table.dataSourceName()));
        return tableEntityMapping;
    }
}

