/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.table;

import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableUtils;
import com.dynamic.sql.table.cte.CTEMeta;
import com.dynamic.sql.table.view.ViewMeta;
import com.dynamic.sql.utils.ReflectUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProvider {
    private static final Logger log = LoggerFactory.getLogger(TableProvider.class);
    private static final Map<Class<?>, TableMeta> TABLE_META_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, CTEMeta> CTE_META_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, ViewMeta> VIEW_META_MAP = new ConcurrentHashMap();

    private TableProvider() {
    }

    protected static void saveTableMeta(Class<?> tableClass, TableMeta tableMeta) {
        if (TABLE_META_MAP.containsKey(tableClass)) {
            log.trace("Data source '{}' has already added table '{}', skip adding this time", (Object)tableMeta.getBindDataSourceName(), (Object)tableMeta.getTableName());
            return;
        }
        TABLE_META_MAP.put(tableClass, tableMeta);
    }

    public static TableMeta getTableMeta(Class<?> tableClass) {
        TableMeta tableMeta = TABLE_META_MAP.get(tableClass);
        if (tableMeta == null) {
            tableMeta = TableUtils.parseTableClass(tableClass);
        }
        return tableMeta;
    }

    public static TableMeta getTableMeta(String classCanonicalName) {
        for (Map.Entry<Class<?>, TableMeta> entry : TABLE_META_MAP.entrySet()) {
            if (!entry.getKey().getCanonicalName().equals(classCanonicalName)) continue;
            return entry.getValue();
        }
        Class<?> loadClass = ReflectUtils.loadClass(classCanonicalName);
        return TableProvider.getTableMeta(loadClass);
    }

    protected static void saveCTEMeta(Class<?> cteClass, CTEMeta cteMeta) {
        if (CTE_META_MAP.containsKey(cteClass)) {
            return;
        }
        CTE_META_MAP.put(cteClass, cteMeta);
    }

    public static CTEMeta getCTEMeta(Class<?> cteClass) {
        return CTE_META_MAP.get(cteClass);
    }

    protected static void saveViewMeta(Class<?> viewClass, ViewMeta viewMeta) {
        if (VIEW_META_MAP.containsKey(viewClass)) {
            log.trace("Already added view '{}', skip adding this time", (Object)viewClass.getCanonicalName());
            return;
        }
        VIEW_META_MAP.put(viewClass, viewMeta);
    }

    public static ViewMeta getViewMeta(Class<?> viewClass) {
        ViewMeta viewMeta = VIEW_META_MAP.get(viewClass);
        if (viewMeta == null) {
            viewMeta = TableUtils.parseViewClass(viewClass);
        }
        return viewMeta;
    }
}

