/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.utils.StringUtils;

public class NamingUtils {
    private NamingUtils() {
    }

    public static String camelToSnakeCase(String camelCaseString) {
        if (camelCaseString == null || camelCaseString.isEmpty()) {
            return camelCaseString;
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase(camelCaseString.charAt(0)));
        for (int i = 1; i < camelCaseString.length(); ++i) {
            char ch = camelCaseString.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (StringUtils.isNotEquals(result.substring(result.length() - 1), "_")) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String snakeToCamelCase(String snakeCaseString) {
        if (snakeCaseString == null || snakeCaseString.isEmpty()) {
            return snakeCaseString;
        }
        if (snakeCaseString.length() == 1) {
            if (snakeCaseString.charAt(0) == '_') {
                return "_";
            }
            return snakeCaseString.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        boolean toUpperCase = false;
        for (char ch : snakeCaseString.toCharArray()) {
            if (ch == '_') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                result.append(Character.toUpperCase(ch));
                toUpperCase = false;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String getBeanName(String beanName, String methodName) {
        if (StringUtils.isNotBlank(beanName)) {
            return beanName.trim();
        }
        if (StringUtils.isBlank(methodName)) {
            throw new IllegalArgumentException("methodName is empty");
        }
        beanName = methodName.trim();
        int length = beanName.length();
        if (length < 3) {
            return beanName;
        }
        String subPrefix = beanName.substring(0, 3);
        if (StringUtils.isEqualsIgnoreCase("get", subPrefix)) {
            beanName = beanName.substring(3);
        }
        String lowerCase = beanName.substring(0, 1).toLowerCase();
        return lowerCase + beanName.substring(1);
    }
}

