/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.conventional.AllColumn;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.conventional.NumberColumn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.column.function.modifiers.Distinct;
import com.dynamic.sql.core.column.function.windows.Over;
import com.dynamic.sql.core.column.function.windows.WindowsFunction;
import com.dynamic.sql.core.dml.select.CollectionColumnMapping;
import com.dynamic.sql.core.dml.select.TableRelation;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.column.ColumnQuery;
import com.dynamic.sql.core.dml.select.build.column.ColumnWrapper;
import com.dynamic.sql.core.dml.select.build.column.NestedColumn;
import com.dynamic.sql.core.dml.select.build.join.FromJoin;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.cte.CteTable;
import com.dynamic.sql.model.KeyMapping;
import com.dynamic.sql.utils.StringUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ColumnReference
extends AbstractColumnReference {
    public ColumnReference(SelectSpecification selectSpecification) {
        super(selectSpecification);
    }

    @Override
    public AbstractColumnReference distinct() {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new Distinct(), null, null));
        return this;
    }

    public static AbstractColumnReference withColumns() {
        return new ColumnReference(new SelectSpecification());
    }

    @Override
    public <T, F> ColumnReference column(Fn<T, F> fn) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new Column(null, fn), null, null));
        return this;
    }

    @Override
    public <T, F> AbstractColumnReference ignoreColumn(Fn<T, F> fn) {
        this.selectSpecification.getIgnoreColumFunctions().add(new ColumnWrapper(new Column(null, fn), null, null));
        return this;
    }

    @Override
    public <T, F> ColumnReference column(String tableAlias, FieldFn<T, F> fn) {
        return this.column(tableAlias, (FieldFn)fn, (String)null);
    }

    @Override
    public <T, F> ColumnReference column(FieldFn<T, F> fn, String columnAlias) {
        return this.column((String)null, (FieldFn)fn, columnAlias);
    }

    @Override
    public <T, F> ColumnReference column(String tableAlias, FieldFn<T, F> fn, String columnAlias) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new Column(tableAlias, fn), null, columnAlias));
        return this;
    }

    @Override
    public AbstractColumnReference column(String tableAlias, String columnName) {
        return this.column(tableAlias, columnName, null);
    }

    @Override
    public AbstractColumnReference column(String tableAlias, String columnName, String columnAlias) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new Column(tableAlias, columnName), null, columnAlias));
        return this;
    }

    @Override
    public ColumnReference column(AbstractColumFunction iColumFunction) {
        this.column(iColumFunction, null);
        return this;
    }

    @Override
    public AbstractColumnReference column(AbstractColumFunction iColumFunction, String columnAlias) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(iColumFunction, null, columnAlias));
        return this;
    }

    @Override
    public AbstractColumnReference column(NumberColumn numberColumn) {
        this.selectSpecification.getColumFunctions().add(numberColumn);
        return this;
    }

    @Override
    public AbstractColumnReference column(WindowsFunction windowsFunction, Consumer<Over> over, String columnAlias) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(windowsFunction, over, columnAlias));
        return this;
    }

    @Override
    public AbstractColumnReference column(Consumer<AbstractColumnReference> nestedSelect, String columnAlias) {
        if (StringUtils.isBlank(columnAlias)) {
            throw new IllegalArgumentException("Subquery must provide an alias");
        }
        NestedColumn nestedColumn = new NestedColumn(nestedSelect, columnAlias);
        this.selectSpecification.getColumFunctions().add(nestedColumn);
        return this;
    }

    @Override
    public AbstractColumnReference collectionColumn(KeyMapping<?, ?> keyMapping, Function<AbstractColumnReference, AbstractColumnReference> valueMapper, String targetProperty) {
        valueMapper.apply(this);
        ColumnReference columnReference = new ColumnReference(new SelectSpecification());
        valueMapper.apply(columnReference);
        List<ColumnQuery> columFunctions = columnReference.getSelectSpecification().getColumFunctions();
        CollectionColumnMapping collectionColumnMapping = new CollectionColumnMapping(keyMapping.parentKey(), keyMapping.childKey());
        collectionColumnMapping.setTargetProperty(targetProperty);
        collectionColumnMapping.addAllChildColumns(columFunctions);
        this.selectSpecification.setCollectionColumnMapping(collectionColumnMapping);
        return this;
    }

    @Override
    @Deprecated
    public AbstractColumnReference columnReference(AbstractColumnReference columnReference) {
        List<ColumnQuery> columFunctions = columnReference.getSelectSpecification().getColumFunctions();
        this.selectSpecification.getColumFunctions().addAll(columFunctions);
        return this;
    }

    @Override
    public AbstractColumnReference allColumn() {
        return this.allColumn((Class)null);
    }

    @Override
    public AbstractColumnReference allColumn(Class<?> tableClass) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new AllColumn(tableClass), null, null));
        return this;
    }

    @Override
    public AbstractColumnReference allColumn(String tableAlias) {
        this.selectSpecification.getColumFunctions().add(new ColumnWrapper(new AllColumn(tableAlias, null), null, null));
        return this;
    }

    @Override
    public <T> TableRelation<T> from(Class<T> tableClass) {
        return this.from(tableClass, null);
    }

    @Override
    public <T> TableRelation<T> from(Class<T> tableClass, String alias) {
        this.selectSpecification.getJoinTables().add(new FromJoin(tableClass, alias));
        return new TableRelation(this.selectSpecification);
    }

    @Override
    public <T> TableRelation<T> from(Supplier<TableFunction> tableFunction, String tableAlias) {
        this.selectSpecification.getJoinTables().add(new FromJoin(tableFunction, tableAlias));
        return new TableRelation(this.selectSpecification);
    }

    @Override
    public TableRelation<?> from(CteTable cteTable) {
        this.selectSpecification.getJoinTables().add(new FromJoin(cteTable));
        return new TableRelation(this.selectSpecification);
    }

    @Override
    public TableRelation<?> from(Consumer<AbstractColumnReference> nestedSelect, String selectAlias) {
        this.selectSpecification.getJoinTables().add(new FromNestedJoin(new NestedJoin(nestedSelect, selectAlias)));
        return new TableRelation(this.selectSpecification);
    }
}

