/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.scalar.geometry;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.scalar.ScalarFunction;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.Point;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.ExceptionUtils;
import java.util.Map;

public class Distance
extends ColumnFunctionDecorator
implements ScalarFunction {
    private Point thisPoint;
    private Point otherPoint;

    public Distance(AbstractColumFunction delegateFunction) {
        super(delegateFunction);
    }

    public <T, F> Distance(FieldFn<T, F> fn, Point thisPoint) {
        super(fn);
        this.thisPoint = thisPoint;
    }

    public Distance(Point thisPoint, Point otherPoint) {
        this.thisPoint = thisPoint;
        this.otherPoint = otherPoint;
    }

    @Override
    public String getFunctionToString(SqlDialect sqlDialect, Version version, Map<String, TableAliasMapping> aliasTableMap) throws UnsupportedOperationException {
        if (sqlDialect == SqlDialect.MYSQL) {
            if (this.otherPoint == null) {
                return "ST_Distance(" + this.delegateFunction.getFunctionToString(sqlDialect, version, aliasTableMap) + ",  ST_GeomFromText('" + this.thisPoint.toPointString() + "', " + this.thisPoint.getSrid() + "))".concat(this.appendArithmeticSql(sqlDialect, version));
            }
            return "ST_Distance(ST_GeomFromText('" + this.thisPoint.toPointString() + "', " + this.thisPoint.getSrid() + "),  ST_GeomFromText('" + this.otherPoint.toPointString() + "', " + this.otherPoint.getSrid() + "))".concat(this.appendArithmeticSql(sqlDialect, version));
        }
        throw ExceptionUtils.unsupportedFunctionException("ST_Distance", sqlDialect);
    }
}

