/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.database.parser.dialect;

import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.database.parser.AbstractDialectParser;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.FieldMeta;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.SqlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OracleParser
extends AbstractDialectParser {
    private final Collection<Object> params;
    private SqlStatementWrapper sqlStatementWrapper;

    public OracleParser(Class<?> entityClass, SchemaProperties schemaProperties, Collection<Object> params, WhereCondition whereCondition) {
        super(entityClass, schemaProperties, whereCondition);
        this.params = params;
    }

    @Override
    public SqlStatementWrapper getSqlStatementWrapper() {
        return this.sqlStatementWrapper;
    }

    @Override
    public void insertSelective(Fn<?, ?>[] forcedFields) {
        this.parseInsert(InsertType.INSERT_SELECTIVE, forcedFields);
    }

    @Override
    public void insert() {
        this.parseInsert(InsertType.INSERT, null);
    }

    @Override
    public void insertBatch() {
        this.parseInsertBatch();
        this.sqlStatementWrapper.setBatchType(SqlStatementWrapper.BatchType.BATCH);
    }

    @Override
    public void insertMultiple() {
        this.parseInsertBatch();
        StringBuilder rawSql = this.sqlStatementWrapper.getRawSql();
        List<ParameterBinder> batchParameterBinders = this.sqlStatementWrapper.getBatchParameterBinders();
        rawSql.append(", ");
        for (int i = 1; i < batchParameterBinders.size(); ++i) {
            ParameterBinder parameterBinder = batchParameterBinders.get(i);
            Collection<Object> values = parameterBinder.getValues();
            rawSql.append("(");
            int j = 0;
            for (Object ignored : values) {
                rawSql.append("?");
                if (j++ >= values.size() - 1) continue;
                rawSql.append(", ");
            }
            rawSql.append(")");
            if (i >= batchParameterBinders.size() - 1) continue;
            rawSql.append(", ");
        }
        this.sqlStatementWrapper.setBatchType(SqlStatementWrapper.BatchType.MULTIPLE);
    }

    @Override
    public void upsert(Fn<?, ?>[] forcedFields) {
        this.upsertEntities(true, forcedFields);
    }

    @Override
    public void upsertMultiple() {
        this.upsertEntities(false, null);
    }

    @Override
    public void upsertSelective(Fn<?, ?>[] forcedFields) {
        this.upsertEntities(true, forcedFields);
    }

    @Override
    public void deleteByPrimaryKey() {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" where ");
        ColumnMeta columnMeta = this.tableMeta.getColumnPrimaryKey();
        if (columnMeta == null) {
            throw new IllegalStateException("The `" + this.tableMeta.getTableName() + "` table does not declare a primary key value");
        }
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), columnMeta.getColumnName()));
        if (this.params.size() > 1) {
            sql.append(" in (");
        } else {
            sql.append(" = ");
        }
        ParameterBinder parameterBinder = new ParameterBinder();
        Iterator<Object> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Object param = iterator.next();
            sql.append(SqlUtils.registerValueWithKey(parameterBinder, param));
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        if (this.params.size() > 1) {
            sql.append(")");
        }
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
    }

    @Override
    public void delete() {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" ");
        if (this.whereCondition == null) {
            this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, null);
            return;
        }
        sql.append(" where ");
        GenericWhereCondition genericWhereCondition = (GenericWhereCondition)this.whereCondition;
        String whereConditionSyntax = genericWhereCondition.getWhereConditionSyntax();
        ParameterBinder parameterBinder = genericWhereCondition.getParameterBinder();
        sql.append(whereConditionSyntax);
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
    }

    @Override
    public void updateByPrimaryKey() {
        this.updateEntityByPrimaryKey(false, null);
    }

    @Override
    public void updateSelectiveByPrimaryKey(Fn<?, ?>[] forcedFields) {
        this.updateEntityByPrimaryKey(true, forcedFields);
    }

    @Override
    public void update() {
        this.updateEntities(false, null);
    }

    @Override
    public void updateSelective(Fn<?, ?>[] forcedFields) {
        this.updateEntities(true, forcedFields);
    }

    private void upsertEntities(boolean isIgnoreNull, Fn<?, ?>[] forcedFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        Iterator<Object> entitiesIterator = this.params.iterator();
        Set<String> forcedFieldNames = this.getForcedFieldNames(forcedFields);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<ParameterBinder> parameterBinders = new ArrayList<ParameterBinder>();
        boolean isRetrieveColumnNames = true;
        while (entitiesIterator.hasNext()) {
            ParameterBinder parameterBinder = new ParameterBinder();
            Object entity = entitiesIterator.next();
            for (FieldMeta column : this.tableMeta.getColumnMetas()) {
                Object fieldValue = ReflectUtils.getFieldValue(entity, column.getField());
                if (fieldValue == null && isIgnoreNull && !forcedFieldNames.contains(column.getField().getName())) continue;
                if (isRetrieveColumnNames) {
                    columns.add(column.getColumnName());
                }
                SqlUtils.registerValueWithKey(parameterBinder, ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, column, fieldValue));
            }
            isRetrieveColumnNames = false;
            if (parameterBinder.isEmpty()) continue;
            parameterBinders.add(parameterBinder);
        }
        if (parameterBinders.isEmpty()) {
            throw new IllegalArgumentException("All upsert parameters are null");
        }
        Iterator iterator = columns.iterator();
        sql.append(" (");
        while (iterator.hasNext()) {
            String columnName = (String)iterator.next();
            sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), columnName));
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") values ");
        Iterator parameterBinderIterator = parameterBinders.iterator();
        while (parameterBinderIterator.hasNext()) {
            ParameterBinder parameterBinder = (ParameterBinder)parameterBinderIterator.next();
            sql.append("(");
            Iterator<String> keyIterator = parameterBinder.getKeys().iterator();
            while (keyIterator.hasNext()) {
                keyIterator.next();
                sql.append("?");
                if (!keyIterator.hasNext()) continue;
                sql.append(", ");
            }
            sql.append(")");
            if (!parameterBinderIterator.hasNext()) continue;
            sql.append(", ");
        }
        Version version = new Version(this.schemaProperties.getMajorVersionNumber(), this.schemaProperties.getMinorVersionNumber(), this.schemaProperties.getPatchVersionNumber());
        boolean isNewVersion = version.isGreaterThanOrEqual(new Version(8, 0, 20));
        if (isNewVersion) {
            sql.append(" as _tmp_upsert");
        }
        sql.append(" on duplicate key update ");
        Iterator iteratorName = columns.iterator();
        while (iteratorName.hasNext()) {
            String columnName = SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), (String)iteratorName.next());
            sql.append(columnName);
            if (isNewVersion) {
                sql.append(" = ").append("_tmp_upsert.").append(columnName);
            } else {
                sql.append(" = values(").append(columnName).append(")");
            }
            if (!iteratorName.hasNext()) continue;
            sql.append(", ");
        }
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql);
        this.sqlStatementWrapper.addBatchParameterBinders(parameterBinders);
        this.sqlStatementWrapper.setBatchType(SqlStatementWrapper.BatchType.MULTIPLE);
    }

    private void updateEntities(boolean isIgnoreNull, Fn<?, ?>[] forcedFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" set ");
        List columnMetas = this.tableMeta.getColumnMetas();
        Iterator iterator = columnMetas.iterator();
        Object entity = this.params.iterator().next();
        ParameterBinder parameterBinder = new ParameterBinder();
        Set<String> forcedFieldNames = this.getForcedFieldNames(forcedFields);
        while (iterator.hasNext()) {
            ColumnMeta column = (ColumnMeta)iterator.next();
            Object fieldValue = ReflectUtils.getFieldValue(entity, column.getField());
            if (fieldValue == null && isIgnoreNull && !forcedFieldNames.contains(column.getField().getName())) continue;
            sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), column.getColumnName()));
            sql.append(" = ");
            Object param = ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, column, fieldValue);
            sql.append(SqlUtils.registerValueWithKey(parameterBinder, param));
            sql.append(", ");
        }
        if (parameterBinder.isEmpty()) {
            throw new IllegalStateException("The `" + this.tableMeta.getTableName() + "` table has no columns that need to be updated");
        }
        sql.setLength(sql.length() - 2);
        if (this.whereCondition == null) {
            this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
            return;
        }
        sql.append(" where ");
        GenericWhereCondition genericWhereCondition = (GenericWhereCondition)this.whereCondition;
        String whereConditionSyntax = genericWhereCondition.getWhereConditionSyntax();
        parameterBinder.addParameterBinder(genericWhereCondition.getParameterBinder());
        sql.append(whereConditionSyntax);
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
    }

    private void updateEntityByPrimaryKey(boolean isIgnoreNull, Fn<?, ?>[] forcedFields) {
        ColumnMeta columnPrimaryKey = this.tableMeta.getColumnPrimaryKey();
        if (columnPrimaryKey == null) {
            throw new IllegalStateException("The `" + this.tableMeta.getTableName() + "` table does not declare a primary key value");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" set ");
        List columnMetas = this.tableMeta.getColumnMetas();
        Iterator iterator = columnMetas.iterator();
        Object entity = this.params.iterator().next();
        ParameterBinder parameterBinder = new ParameterBinder();
        Set<String> forcedFieldNames = this.getForcedFieldNames(forcedFields);
        while (iterator.hasNext()) {
            Object fieldValue;
            ColumnMeta column = (ColumnMeta)iterator.next();
            if (column.equals(columnPrimaryKey) || (fieldValue = ReflectUtils.getFieldValue(entity, column.getField())) == null && isIgnoreNull && !forcedFieldNames.contains(column.getField().getName())) continue;
            sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), column.getColumnName()));
            sql.append(" = ");
            Object param = ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, column, fieldValue);
            sql.append(SqlUtils.registerValueWithKey(parameterBinder, param));
            sql.append(", ");
        }
        if (parameterBinder.isEmpty()) {
            throw new IllegalStateException("The `" + this.tableMeta.getTableName() + "` table has no columns that need to be updated");
        }
        sql.setLength(sql.length() - 2);
        sql.append(" where ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), columnPrimaryKey.getColumnName()));
        sql.append(" = ");
        Object fieldValue = ReflectUtils.getFieldValue(entity, columnPrimaryKey.getField());
        Object param = ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, columnPrimaryKey, fieldValue);
        sql.append(SqlUtils.registerValueWithKey(parameterBinder, param));
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
    }

    private void parseInsert(InsertType insertType, Fn<?, ?>[] forcedFields) {
        List columnMetas = this.tableMeta.getColumnMetas();
        Set<String> forcedFieldNames = this.getForcedFieldNames(forcedFields);
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" (");
        Object entity = this.params.iterator().next();
        ArrayList<String> insertColumns = new ArrayList<String>();
        for (ColumnMeta columnMeta : columnMetas) {
            Object fieldValue = ReflectUtils.getFieldValue(entity, columnMeta.getField());
            if (fieldValue == null && insertType != InsertType.INSERT && !forcedFieldNames.contains(columnMeta.getColumnName())) continue;
            insertColumns.add(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), columnMeta.getColumnName()));
            values.add(ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, columnMeta, fieldValue));
        }
        if (values.isEmpty()) {
            throw new IllegalStateException("No non-null attribute fields were provided.");
        }
        sql.append(String.join((CharSequence)", ", insertColumns));
        sql.append(") VALUES (");
        ParameterBinder parameterBinder = new ParameterBinder();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            sql.append(SqlUtils.registerValueWithKey(parameterBinder, value));
            if (i >= values.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql, parameterBinder);
    }

    private void parseInsertBatch() {
        List columnMetas = this.tableMeta.getColumnMetas();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), this.tableMeta.getTableName()));
        sql.append(" (");
        StringBuilder placeHolders = new StringBuilder();
        for (int i = 0; i < columnMetas.size(); ++i) {
            ColumnMeta columnMeta = (ColumnMeta)columnMetas.get(i);
            sql.append(SqlUtils.quoteIdentifier(this.schemaProperties.getSqlDialect(), columnMeta.getColumnName()));
            placeHolders.append("?");
            if (i >= columnMetas.size() - 1) continue;
            sql.append(", ");
            placeHolders.append(", ");
        }
        sql.append(") values (").append((CharSequence)placeHolders).append(")");
        this.sqlStatementWrapper = new SqlStatementWrapper(this.schemaProperties.getDataSourceName(), sql);
        for (Object entity : this.params) {
            ParameterBinder parameterBinder = new ParameterBinder();
            for (ColumnMeta columnMeta : columnMetas) {
                Object fieldValue = ReflectUtils.getFieldValue(entity, columnMeta.getField());
                SqlUtils.registerValueWithKey(parameterBinder, ConverterUtils.convertToDatabaseColumn(SqlDialect.ORACLE, columnMeta, fieldValue));
            }
            this.sqlStatementWrapper.addBatchParameterBinder(parameterBinder);
        }
    }

    private Set<String> getForcedFieldNames(Fn<?, ?>[] forcedFields) {
        HashSet<String> forcedFieldNames = new HashSet<String>();
        if (forcedFields == null || forcedFields.length < 1) {
            return forcedFieldNames;
        }
        for (Fn<?, ?> fn : forcedFields) {
            String fieldName = ReflectUtils.fnToFieldName(fn);
            forcedFieldNames.add(fieldName);
        }
        return forcedFieldNames;
    }

    static enum InsertType {
        INSERT,
        INSERT_SELECTIVE;

    }
}

