/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml;

import com.dynamic.sql.core.placeholder.ParameterBinder;
import java.util.ArrayList;
import java.util.List;

public class SqlStatementWrapper {
    private final String dataSourceName;
    private final StringBuilder rawSql;
    private final List<ParameterBinder> parameterBinders = new ArrayList<ParameterBinder>();
    private BatchType batchType;

    public SqlStatementWrapper(String dataSourceName, StringBuilder rawSql, ParameterBinder parameterBinder) {
        this.dataSourceName = dataSourceName;
        this.rawSql = rawSql;
        this.parameterBinders.add(parameterBinder);
    }

    public SqlStatementWrapper(String dataSourceName, StringBuilder rawSql) {
        this.dataSourceName = dataSourceName;
        this.rawSql = rawSql;
    }

    public StringBuilder getRawSql() {
        return this.rawSql;
    }

    public ParameterBinder getParameterBinder() {
        return this.parameterBinders.get(0);
    }

    public List<ParameterBinder> getBatchParameterBinders() {
        return this.parameterBinders;
    }

    public void addBatchParameterBinder(ParameterBinder parameterBinder) {
        this.parameterBinders.add(parameterBinder);
    }

    public void addBatchParameterBinders(List<ParameterBinder> parameterBinders) {
        this.parameterBinders.addAll(parameterBinders);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setBatchType(BatchType batchType) {
        this.batchType = batchType;
    }

    public BatchType getBatchType() {
        return this.batchType;
    }

    public static enum BatchType {
        BATCH,
        MULTIPLE;

    }
}

