/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination;

import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.PageHelper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class PageInfo<T>
extends AbstractPage {
    private T records;
    private Supplier<T> selectSupplier;

    public PageInfo(int pageIndex, int pageSize) {
        super(pageIndex, pageSize);
    }

    protected PageInfo(int pageIndex, int pageSize, String pagePluginTypeName) {
        super(pageIndex, pageSize, pagePluginTypeName);
    }

    @Override
    void setRecords(Supplier<?> selectSupplier) {
        this.selectSupplier = selectSupplier;
        this.records = this.selectSupplier.get();
    }

    public T getRecords() {
        return this.records;
    }

    @Override
    public int getRealSize() {
        if (this.records instanceof Collection) {
            return ((Collection)this.records).size();
        }
        if (this.records instanceof Map) {
            return ((Map)this.records).size();
        }
        throw new IllegalStateException("Unsupported records type: " + this.records.getClass().getCanonicalName());
    }

    public static <T> PageInfo<T> empty() {
        return PageInfo.empty(1, 10, null);
    }

    public static <T> PageInfo<T> empty(int pageIndex, int pageSize) {
        return PageInfo.empty(pageIndex, pageSize, null);
    }

    public static <T> PageInfo<T> empty(int pageIndex, int pageSize, T records) {
        PageInfo<T> page = new PageInfo<T>(pageIndex, pageSize);
        page.total = 0L;
        page.totalPage = 0;
        page.records = records;
        return page;
    }

    public boolean isEmpty() {
        return this.getRealSize() <= 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Deprecated
    public PageInfo<T> selectNextPage(Supplier<T> selectSupplier) {
        ++this.pageIndex;
        return PageHelper.of(this).selectPage(selectSupplier);
    }

    public void selectNextPage() {
        ++this.pageIndex;
        PageHelper.of(this).selectPage(this.selectSupplier);
    }

    public void setRecords(T records) {
        this.records = records;
    }

    @Override
    public void setTotal(long total) {
        this.total = total;
        this.initTotalPage();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PageInfo{");
        sb.append("pageIndex=").append(this.pageIndex);
        sb.append(", pageSize=").append(this.pageSize);
        sb.append(", realSize=").append(this.getRealSize());
        sb.append(", total=").append(this.total);
        sb.append(", totalPage=").append(this.totalPage);
        sb.append(", records=").append(this.records);
        sb.append('}');
        return sb.toString();
    }
}

