/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.schema.impl;

import com.dynamic.sql.enums.DbType;
import com.dynamic.sql.plugins.schema.DbSchemaMatcher;

public class OracleSchemaMatcher
implements DbSchemaMatcher {
    @Override
    public String matchSchema(String url) {
        String oracleUrl = url.substring("jdbc:oracle:thin:@".length());
        if (oracleUrl.startsWith("//")) {
            String[] parts = oracleUrl.substring(2).split("/");
            if (parts.length > 1) {
                return parts[1].split("\\?")[0];
            }
        } else {
            String[] parts = oracleUrl.split(":");
            if (parts.length == 3) {
                return parts[2];
            }
            if (parts.length == 2) {
                return parts[1];
            }
        }
        return null;
    }

    @Override
    public boolean supports(DbType dbType) {
        return dbType.equals((Object)DbType.ORACLE);
    }
}

