/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.core.column.function.AnonymousFunction;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.plugins.conversion.AttributeConverter;
import com.dynamic.sql.plugins.conversion.AttributeConverterModel;
import com.dynamic.sql.plugins.conversion.FetchResultConverter;
import com.dynamic.sql.plugins.conversion.attribute.BigDecimalAttributeConverter;
import com.dynamic.sql.plugins.conversion.attribute.LocalDateAttributeConverter;
import com.dynamic.sql.table.FieldMeta;
import com.dynamic.sql.utils.ReflectUtils;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class ConverterUtils {
    private static final Map<Class<? extends AttributeConverter>, AttributeConverter> CUSTOM_ATTRIBUTE_CONVERTERS = new LinkedHashMap<Class<? extends AttributeConverter>, AttributeConverter>();
    private static final Map<Class<?>, AttributeConverterModel> GENERAL_ATTRIBUTE_CONVERTER_MODEL = new LinkedHashMap();
    private static final Map<Class<?>, FetchResultConverter> FETCH_RESULT_CONVERTER_MAP = new LinkedHashMap();
    private static final Map<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();

    private ConverterUtils() {
    }

    public static <Y> AttributeConverter<Object, Y> loadCustomConverter(Class<? extends AttributeConverter> converterClass) {
        AttributeConverter attributeConverter = CUSTOM_ATTRIBUTE_CONVERTERS.get(converterClass);
        if (attributeConverter != null) {
            return attributeConverter;
        }
        AttributeConverter instance = ReflectUtils.instance(converterClass, new Object[0]);
        CUSTOM_ATTRIBUTE_CONVERTERS.put(converterClass, instance);
        return instance;
    }

    public static Object convertToDatabaseColumn(SqlDialect sqlDialect, FieldMeta fieldMeta, Object value) {
        AttributeConverter attributeConverter;
        if (value == null) {
            return null;
        }
        if (value instanceof AttributeConverter && !(attributeConverter = (AttributeConverter)value).isSkipConvertToDatabaseColumn(value)) {
            return attributeConverter.convertToDatabaseColumn((Object)value);
        }
        if (fieldMeta.getConverter() != null && !(attributeConverter = ConverterUtils.loadCustomConverter(fieldMeta.getConverter())).isSkipConvertToDatabaseColumn(value)) {
            return attributeConverter.convertToDatabaseColumn(value);
        }
        attributeConverter = GENERAL_ATTRIBUTE_CONVERTER_MODEL.get(fieldMeta.getField().getType());
        if (attributeConverter != null && !attributeConverter.isSkipConvertToDatabaseColumn(value)) {
            return attributeConverter.convertToDatabaseColumn(value);
        }
        String format = fieldMeta.getFormat();
        if (format != null) {
            String formattedValue = ConverterUtils.formatterDateValue(value, format);
            if (sqlDialect == SqlDialect.ORACLE) {
                ParameterBinder parameterBinder = new ParameterBinder();
                if (value instanceof LocalDate || value instanceof Date) {
                    return new AnonymousFunction("TO_DATE('" + formattedValue + "', '" + format + "')", parameterBinder);
                }
                return new AnonymousFunction("TO_TIMESTAMP('" + formattedValue + "', '" + format + "')", parameterBinder);
            }
            return formattedValue;
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return enumValue.name();
        }
        return value;
    }

    public static String formatterDateValue(Object dateValue, String pattern) {
        java.util.Date date;
        TemporalAccessor temporal;
        if (dateValue instanceof TemporalAccessor) {
            temporal = (TemporalAccessor)dateValue;
        } else if (dateValue instanceof Date) {
            date = (Date)dateValue;
            temporal = ((Date)date).toLocalDate();
        } else if (dateValue instanceof Time) {
            Time time = (Time)dateValue;
            temporal = time.toLocalTime();
        } else if (dateValue instanceof java.util.Date) {
            date = (java.util.Date)dateValue;
            temporal = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else {
            throw new UnsupportedOperationException("Unsupported date type: " + dateValue.getClass());
        }
        DateTimeFormatter formatter = FORMATTER_CACHE.computeIfAbsent(pattern, DateTimeFormatter::ofPattern);
        return formatter.format(temporal);
    }

    public static <T, V> T convertToEntityAttribute(FieldMeta fieldMeta, @Nonnull Class<T> fieldType, V value) {
        AttributeConverter attributeConverter;
        if (value == null) {
            return null;
        }
        if (value instanceof AttributeConverter && !(attributeConverter = (AttributeConverter)value).isSkipConvertToEntityAttribute(value)) {
            return (T)attributeConverter.convertToEntityAttribute(value);
        }
        Class<?> valueType = value.getClass();
        if (fieldType.isAssignableFrom(valueType)) {
            return (T)value;
        }
        AttributeConverter<Object, V> customAttributeConverter = CUSTOM_ATTRIBUTE_CONVERTERS.get(fieldType);
        if (customAttributeConverter == null && fieldMeta != null && fieldMeta.getConverter() != null) {
            customAttributeConverter = ConverterUtils.loadCustomConverter(fieldMeta.getConverter());
        }
        if (customAttributeConverter != null && !customAttributeConverter.isSkipConvertToEntityAttribute(value)) {
            return (T)customAttributeConverter.convertToEntityAttribute(value);
        }
        AttributeConverter attributeConverter2 = GENERAL_ATTRIBUTE_CONVERTER_MODEL.get(fieldType);
        if (attributeConverter2 != null && !attributeConverter2.isSkipConvertToEntityAttribute(value)) {
            return (T)attributeConverter2.convertToEntityAttribute(value);
        }
        if (fieldType == String.class) {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                try {
                    return (T)clob.getSubString(1L, Long.valueOf(clob.length()).intValue());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Clob cannot be written to String", e);
                }
            }
            return (T)value.toString();
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return (T)ConverterUtils.toInteger(value);
        }
        if (fieldType == Long.class || fieldType == Long.TYPE) {
            return (T)ConverterUtils.toLong(value);
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            return (T)ConverterUtils.toBoolean(value);
        }
        if (fieldType == Double.class || fieldType == Double.TYPE) {
            return (T)Double.valueOf(ConverterUtils.ifBooleanToNumber(value).toString());
        }
        if (fieldType == Float.class || fieldType == Float.TYPE) {
            return (T)Float.valueOf(ConverterUtils.ifBooleanToNumber(value).toString());
        }
        if (fieldType == AtomicInteger.class) {
            return (T)new AtomicInteger(ConverterUtils.toInteger(value));
        }
        if (fieldType == AtomicBoolean.class) {
            return (T)new AtomicBoolean(ConverterUtils.toBoolean(value));
        }
        if (fieldType == AtomicLong.class) {
            return (T)new AtomicLong(ConverterUtils.toLong(value));
        }
        if (fieldType == LocalDateTime.class && value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return (T)timestamp.toLocalDateTime();
        }
        if (fieldType == YearMonth.class) {
            return (T)YearMonth.parse(value.toString());
        }
        if (fieldType == Year.class) {
            return (T)Year.parse(value.toString());
        }
        if (fieldType.isEnum()) {
            T[] enumConstants = fieldType.getEnumConstants();
            if (enumConstants == null) {
                return null;
            }
            if (AttributeConverter.class.isAssignableFrom(fieldType)) {
                AttributeConverter attributeConverterEnum = (AttributeConverter)enumConstants[0];
                return (T)attributeConverterEnum.convertToEntityAttribute(value);
            }
            for (T enumObj : enumConstants) {
                if (!enumObj.toString().equals(value.toString())) continue;
                return enumObj;
            }
        }
        throw new IllegalArgumentException("Cannot convert value of type " + valueType + " to field type " + fieldType + ", Value is [" + value + "]");
    }

    private static <T, V> T toByte(V value, Class<T> fieldType) {
        if (Byte[].class.isAssignableFrom(fieldType) && value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            Byte[] byteArrayObject = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                byteArrayObject[i] = bytes[i];
            }
            return (T)byteArrayObject;
        }
        return (T)value;
    }

    public static Integer toInteger(Object value) {
        if (value instanceof Double) {
            Integer intValue = ((Double)value).intValue();
            return intValue;
        }
        return Integer.valueOf(ConverterUtils.ifBooleanToNumber(value).toString());
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            Boolean b = number.intValue() == 1;
            return b;
        }
        return Boolean.valueOf(value.toString());
    }

    public static Long toLong(Object value) {
        return Long.valueOf(ConverterUtils.ifBooleanToNumber(value).toString());
    }

    public static void putAttributeConverterModel(Class<?> fieldType, AttributeConverterModel attributeConverter) {
        GENERAL_ATTRIBUTE_CONVERTER_MODEL.put(fieldType, attributeConverter);
    }

    public static void putCustomAttributeConverter(Class<? extends AttributeConverter> fieldType, AttributeConverter attributeConverter) {
        CUSTOM_ATTRIBUTE_CONVERTERS.put(fieldType, attributeConverter);
    }

    public static void putFetchResultConverter(Class<?> targetType, FetchResultConverter fetchResultConverter) {
        FETCH_RESULT_CONVERTER_MAP.put(targetType, fetchResultConverter);
    }

    public static Object ifBooleanToNumber(Object value) {
        if (value instanceof Boolean) {
            return Boolean.compare((Boolean)value, false);
        }
        return value;
    }

    public static <R> FetchResultConverter<R> getFetchResultConverter(Class<R> resultClass) {
        return FETCH_RESULT_CONVERTER_MAP.get(resultClass);
    }

    public static <R, X, Y> AttributeConverter<X, Y> getCustomAttributeConverter(Class<R> resultClass) {
        return CUSTOM_ATTRIBUTE_CONVERTERS.get(resultClass);
    }

    public static <R, X, Y> AttributeConverter<X, Y> getOrSetCustomAttributeConverter(Class<R> resultClass) {
        AttributeConverter customAttributeConverter = ConverterUtils.getCustomAttributeConverter(resultClass);
        if (customAttributeConverter == null) {
            customAttributeConverter = (AttributeConverter)ReflectUtils.instance(resultClass, new Object[0]);
            ConverterUtils.putCustomAttributeConverter(resultClass, customAttributeConverter);
        }
        return customAttributeConverter;
    }

    static {
        ConverterUtils.putAttributeConverterModel(BigDecimal.class, new BigDecimalAttributeConverter());
        ConverterUtils.putAttributeConverterModel(LocalDate.class, new LocalDateAttributeConverter());
    }
}

