/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.ColumnArithmetic;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.Arithmetic;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Map;

public abstract class AbstractColumFunction
implements ColumFunction,
ColumnArithmetic {
    protected AbstractColumFunction delegateFunction;
    private Map<String, TableAliasMapping> aliasTableMap;
    private String dataSourceName;
    private Arithmetic arithmetic = new Arithmetic(new StringBuilder(), new ParameterBinder());

    @Override
    public AbstractColumFunction subtract(Number value) {
        this.arithmetic.getArithmeticSql().append(" - ").append(SqlUtils.registerValueWithKey(this.arithmetic.getArithmeticParameterBinder(), value));
        return this;
    }

    @Override
    public AbstractColumFunction subtract(SelectDsl nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmetic.getArithmeticSql().append(" - (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmetic.getArithmeticParameterBinder().addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction subtract(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmetic.getArithmeticSql().append(" - ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction subtract(ColumFunction columFunction) {
        return this;
    }

    @Override
    public AbstractColumFunction multiply(Number value) {
        this.arithmetic.getArithmeticSql().append(" * ").append(SqlUtils.registerValueWithKey(this.arithmetic.getArithmeticParameterBinder(), value));
        return this;
    }

    @Override
    public AbstractColumFunction multiply(SelectDsl nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmetic.getArithmeticSql().append(" * (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmetic.getArithmeticParameterBinder().addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction multiply(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmetic.getArithmeticSql().append(" * ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction multiply(ColumFunction columFunction) {
        return this;
    }

    @Override
    public AbstractColumFunction divide(Number value) {
        this.arithmetic.getArithmeticSql().append(" / ").append(SqlUtils.registerValueWithKey(this.arithmetic.getArithmeticParameterBinder(), value));
        return this;
    }

    @Override
    public AbstractColumFunction divide(SelectDsl nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmetic.getArithmeticSql().append(" / (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmetic.getArithmeticParameterBinder().addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction divide(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmetic.getArithmeticSql().append(" / ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction divide(ColumFunction columFunction) {
        this.arithmetic.setColumFunctionArithmetic(columFunction);
        this.arithmetic.getArithmeticSql().append(" / ");
        return this;
    }

    @Override
    public AbstractColumFunction add(Number value) {
        this.arithmetic.getArithmeticSql().append(" + ").append(SqlUtils.registerValueWithKey(this.arithmetic.getArithmeticParameterBinder(), value));
        return this;
    }

    @Override
    public AbstractColumFunction add(SelectDsl nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmetic.getArithmeticSql().append(" + (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmetic.getArithmeticParameterBinder().addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction add(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmetic.getArithmeticSql().append(" + ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction add(ColumFunction columFunction) {
        return this;
    }

    public AbstractColumFunction getDelegateFunction() {
        return this.delegateFunction;
    }

    public Map<String, TableAliasMapping> getAliasTableMap() {
        return this.aliasTableMap;
    }

    public void setAliasTableMap(Map<String, TableAliasMapping> aliasTableMap) {
        if (aliasTableMap == null) {
            throw new DynamicSqlException("Parameters must be set before calling: aliasTableMap");
        }
        this.aliasTableMap = aliasTableMap;
    }

    public String getDataSourceName() {
        if (this.dataSourceName == null) {
            throw new DynamicSqlException("Parameters must be set before calling: dataSourceName");
        }
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public Arithmetic getArithmetic() {
        return this.arithmetic;
    }

    public void setArithmetic(Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }
}

