/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.AnonymousFunction;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.model.Arithmetic;
import java.io.Serializable;

public abstract class ColumnFunctionDecorator
extends AbstractColumFunction
implements Serializable {
    protected Integer value;
    protected ParameterBinder parameterBinder = new ParameterBinder();

    public ColumnFunctionDecorator() {
        this.delegateFunction = new AnonymousFunction();
    }

    public ColumnFunctionDecorator(AbstractColumFunction delegateFunction) {
        this.delegateFunction = delegateFunction;
    }

    public <T, F> ColumnFunctionDecorator(FieldFn<T, F> fn) {
        this.delegateFunction = new Column(null, fn);
    }

    public <T, F> ColumnFunctionDecorator(String tableAlias, FieldFn<T, F> fn) {
        this.delegateFunction = new Column(tableAlias, fn);
    }

    public ColumnFunctionDecorator(String tableAlias, String columnName) {
        this.delegateFunction = new Column(tableAlias, columnName);
    }

    public ColumnFunctionDecorator(int value) {
        this.value = value;
    }

    @Override
    public Fn<?, ?> originColumn() {
        return this.delegateFunction.originColumn();
    }

    @Override
    public ParameterBinder parameterBinder() {
        return this.parameterBinder.addParameterBinder(this.delegateFunction.parameterBinder());
    }

    @Override
    public String getTableAlias() {
        return this.delegateFunction.getTableAlias();
    }

    protected String appendArithmeticSql(RenderContext context) {
        Arithmetic arithmetic = this.getArithmetic();
        if (arithmetic == null) {
            return "";
        }
        ColumFunction columFunctionArithmetic = arithmetic.getColumFunctionArithmetic();
        if (columFunctionArithmetic == null) {
            this.parameterBinder.addParameterBinder(arithmetic.getArithmeticParameterBinder());
            return arithmetic.getArithmeticSql().toString();
        }
        String render = columFunctionArithmetic.render(context);
        this.parameterBinder.addParameterBinder(columFunctionArithmetic.parameterBinder());
        return arithmetic.getArithmeticSql().append(render).toString();
    }
}

