/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.modifiers;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.ColumnModifiers;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.utils.ExceptionUtils;
import com.dynamic.sql.utils.StringUtils;

public class Distinct
extends ColumnFunctionDecorator
implements ColumnModifiers {
    Boolean shouldAppendDelimiter = null;

    public Distinct(AbstractColumFunction delegateFunction) {
        super(delegateFunction);
    }

    public <T, F> Distinct(FieldFn<T, F> fn) {
        super(fn);
    }

    public <T, F> Distinct(String tableAlias, FieldFn<T, F> fn) {
        super(tableAlias, fn);
    }

    public Distinct() {
    }

    @Override
    public boolean shouldAppendDelimiter() {
        if (this.shouldAppendDelimiter == null) {
            throw new DynamicSqlException("You need to call the getFunctionToString function first");
        }
        return this.shouldAppendDelimiter;
    }

    @Override
    public String render(RenderContext context) {
        String functionToString = this.delegateFunction.render(context);
        this.shouldAppendDelimiter = !StringUtils.isBlank(functionToString);
        if (this.shouldAppendDelimiter.booleanValue()) {
            if (context.getSqlDialect() == SqlDialect.ORACLE) {
                return "DISTINCT(" + this.delegateFunction.render(context) + ")".concat(this.appendArithmeticSql(context));
            }
            if (context.getSqlDialect() == SqlDialect.MYSQL) {
                return "distinct(" + this.delegateFunction.render(context) + ")".concat(this.appendArithmeticSql(context));
            }
        } else {
            if (context.getSqlDialect() == SqlDialect.ORACLE) {
                return "DISTINCT";
            }
            if (context.getSqlDialect() == SqlDialect.MYSQL) {
                return "distinct";
            }
        }
        throw ExceptionUtils.unsupportedFunctionException("distinct", context.getSqlDialect());
    }
}

