/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.scalar.geometry;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.scalar.ScalarFunction;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.Point;
import com.dynamic.sql.utils.ExceptionUtils;
import com.dynamic.sql.utils.SqlUtils;

public class Contains
extends ColumnFunctionDecorator
implements ScalarFunction {
    private final Point point;

    public <T, F> Contains(FieldFn<T, F> fn, Point point) {
        super(fn);
        this.point = point;
    }

    @Override
    public String render(RenderContext context) {
        if (context.getSqlDialect() == SqlDialect.MYSQL) {
            String name = SqlUtils.extractQualifiedAlias(this.delegateFunction.originColumn(), context.getAliasTableMap(), context.getDataSourceName());
            SqlUtils.registerValueWithKey(this.parameterBinder, this.delegateFunction.originColumn(), this.value, context.getSqlDialect());
            return "ST_Contains(" + name + ", ST_PointFromText('" + this.point.toPointString() + "'," + this.point.getSrid() + "));";
        }
        throw ExceptionUtils.unsupportedFunctionException("ST_Contains", context.getSqlDialect());
    }
}

