/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.scalar.geometry;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.scalar.ScalarFunction;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.Point;
import com.dynamic.sql.utils.ExceptionUtils;

public class Distance
extends ColumnFunctionDecorator
implements ScalarFunction {
    private Point thisPoint;
    private Point otherPoint;

    public Distance(AbstractColumFunction delegateFunction) {
        super(delegateFunction);
    }

    public <T, F> Distance(FieldFn<T, F> fn, Point thisPoint) {
        super(fn);
        this.thisPoint = thisPoint;
    }

    public Distance(Point thisPoint, Point otherPoint) {
        this.thisPoint = thisPoint;
        this.otherPoint = otherPoint;
    }

    @Override
    public String render(RenderContext context) {
        if (context.getSqlDialect() == SqlDialect.MYSQL) {
            if (this.otherPoint == null) {
                return "ST_Distance(" + this.delegateFunction.render(context) + ",  ST_GeomFromText('" + this.thisPoint.toPointString() + "', " + this.thisPoint.getSrid() + "))".concat(this.appendArithmeticSql(context));
            }
            return "ST_Distance(ST_GeomFromText('" + this.thisPoint.toPointString() + "', " + this.thisPoint.getSrid() + "),  ST_GeomFromText('" + this.otherPoint.toPointString() + "', " + this.otherPoint.getSrid() + "))".concat(this.appendArithmeticSql(context));
        }
        throw ExceptionUtils.unsupportedFunctionException("ST_Distance", context.getSqlDialect());
    }
}

