/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.scalar.number;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumnFunctionDecorator;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.scalar.number.NumberFunction;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.utils.ExceptionUtils;

public class Mod
extends ColumnFunctionDecorator
implements NumberFunction {
    private final int divisor;

    public Mod(AbstractColumFunction delegateFunction, int divisor) {
        super(delegateFunction);
        this.divisor = divisor;
    }

    public <T, F> Mod(FieldFn<T, F> fn, int divisor) {
        super(fn);
        this.divisor = divisor;
    }

    @Override
    public String render(RenderContext context) {
        if (context.getSqlDialect() == SqlDialect.ORACLE) {
            return "MOD(" + this.delegateFunction.render(context) + ", " + this.divisor + ")".concat(this.appendArithmeticSql(context));
        }
        if (context.getSqlDialect() == SqlDialect.MYSQL) {
            return "mod(" + this.delegateFunction.render(context) + ", " + this.divisor + ")".concat(this.appendArithmeticSql(context));
        }
        throw ExceptionUtils.unsupportedFunctionException("MOD", context.getSqlDialect());
    }
}

