/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function.table;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.column.AbstractAliasHelper;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.column.function.table.AbstractTableFunction;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.utils.SqlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonTable
extends AbstractTableFunction {
    private String path;
    private List<JsonColumn> columns = new ArrayList<JsonColumn>();
    private ParameterBinder parameterBinder;

    public JsonTable(TableFunction tableFunction, String path, JsonColumn ... jsonColumn) {
        super(tableFunction);
        this.path = path;
        if (jsonColumn == null || jsonColumn.length <= 0) {
            throw new DynamicSqlException("The extracted Json column must be declared");
        }
        this.columns.addAll(Arrays.asList(jsonColumn));
    }

    public <T, F> JsonTable(FieldFn<T, F> fn, String path, JsonColumn ... jsonColumn) {
        super(fn);
        this.path = path;
        if (jsonColumn == null || jsonColumn.length <= 0) {
            throw new DynamicSqlException("The extracted Json column must be declared");
        }
        this.columns.addAll(Arrays.asList(jsonColumn));
    }

    public <T, F> JsonTable(String tableAlias, FieldFn<T, F> fn, String path, JsonColumn ... jsonColumn) {
        super(AbstractAliasHelper.bindAlias(tableAlias, fn));
        this.path = path;
        if (jsonColumn == null || jsonColumn.length <= 0) {
            throw new DynamicSqlException("The extracted Json column must be declared");
        }
        this.columns.addAll(Arrays.asList(jsonColumn));
    }

    public JsonTable(String columnName, String path, JsonColumn ... jsonColumn) {
        super(AbstractAliasHelper.bindAlias(null, columnName));
        this.path = path;
        if (jsonColumn == null || jsonColumn.length <= 0) {
            throw new DynamicSqlException("The extracted Json column must be declared");
        }
        this.columns.addAll(Arrays.asList(jsonColumn));
    }

    public JsonTable(String tableAlias, String columnName, String path, JsonColumn ... jsonColumn) {
        super(AbstractAliasHelper.bindAlias(tableAlias, columnName));
        this.path = path;
        if (jsonColumn == null || jsonColumn.length <= 0) {
            throw new DynamicSqlException("The extracted Json column must be declared");
        }
        this.columns.addAll(Arrays.asList(jsonColumn));
    }

    @Override
    public ParameterBinder parameterBinder() {
        return this.parameterBinder;
    }

    @Override
    public String render(RenderContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("json_table(").append(this.tableFunction.render(context)).append(", '").append(this.path).append("' columns(");
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append(this.columns.get(i).toString());
            if (i >= this.columns.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("))");
        return sb.toString();
    }

    public static class JsonColumnBuilder {
        private JsonColumn jsonColumn;

        public JsonColumnBuilder(JsonColumn jsonColumn) {
            this.jsonColumn = jsonColumn;
        }

        public JsonColumnBuilder column(String columnName) {
            this.jsonColumn.columnName = columnName;
            return this;
        }

        public JsonColumnBuilder dataType(String dataType) {
            this.jsonColumn.dataType = dataType;
            return this;
        }

        public JsonColumnBuilder jsonPath(String jsonPath) {
            this.jsonColumn.jsonPath = jsonPath;
            return this;
        }

        public JsonColumnBuilder defaultValue(Object defaultValue) {
            this.jsonColumn.defaultValue = defaultValue;
            return this;
        }

        public JsonColumn.OnEvent on() {
            JsonColumn.OnEvent onEvent = new JsonColumn.OnEvent(this);
            this.jsonColumn.on.add(onEvent);
            return onEvent;
        }

        protected void appendOn(JsonColumn.OnEvent onEvent) {
            this.jsonColumn.on.add(onEvent);
        }

        public JsonColumn build() {
            return this.jsonColumn;
        }
    }

    public static class JsonColumn {
        protected String columnName;
        protected String dataType;
        protected String jsonPath;
        protected Object defaultValue;
        protected List<OnEvent> on = new ArrayList<OnEvent>();

        protected JsonColumn() {
        }

        public static JsonColumnBuilder builder() {
            return new JsonColumnBuilder(new JsonColumn());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.columnName).append(" ").append(this.dataType).append(" path '").append(this.jsonPath).append("' ");
            if (this.defaultValue != null) {
                Object v = SqlUtils.formattedParameter(this.defaultValue);
                stringBuilder.append("default ").append(v).append(" ");
            }
            for (OnEvent onEvent : this.on) {
                stringBuilder.append(" on ").append(onEvent.getEvent()).append(" ");
                if (onEvent.getDefaultValue() == null) continue;
                Object v = SqlUtils.formattedParameter(this.defaultValue);
                stringBuilder.append("default ").append(v).append(" ");
            }
            return stringBuilder.toString();
        }

        public static class OnEvent {
            protected JsonColumnBuilder jsonColumnBuilder;
            private String event;
            private Object defaultValue;

            public OnEvent(JsonColumnBuilder jsonColumnBuilder) {
                this.jsonColumnBuilder = jsonColumnBuilder;
            }

            public OnEvent error() {
                this.event = "error";
                return this;
            }

            public OnEvent empty() {
                this.event = "empty";
                return this;
            }

            public OnEvent defaultValue(Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public OnEvent on() {
                OnEvent onEvent = new OnEvent(this.jsonColumnBuilder);
                this.jsonColumnBuilder.appendOn(onEvent);
                return onEvent;
            }

            public JsonColumn build() {
                return this.jsonColumnBuilder.build();
            }

            protected String getEvent() {
                return this.event;
            }

            protected Object getDefaultValue() {
                return this.defaultValue;
            }
        }
    }
}

