/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.condition.impl.dialect;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.windows.aggregate.AggregateFunction;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.MysqlWhereCondition;
import com.dynamic.sql.core.dml.select.NestedMeta;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.enums.SqlExecuteType;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class GenericWhereCondition
extends WhereCondition<GenericWhereCondition> {
    protected final Version version;
    protected final Map<String, TableAliasMapping> aliasTableMap;
    protected final StringBuilder condition = new StringBuilder();
    protected final ParameterBinder parameterBinder = new ParameterBinder();
    protected String dataSourceName;
    protected boolean isFirstBuild;
    protected SqlExecuteType sqlExecuteType;

    public GenericWhereCondition(Version version, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName) {
        this.version = version;
        this.aliasTableMap = aliasTableMap;
        this.isFirstBuild = true;
        this.dataSourceName = dataSourceName;
    }

    @Override
    public <T, F> GenericWhereCondition andEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" = ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public GenericWhereCondition andEqualTo(Object value, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value)).append(" = ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" = ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(Object value, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value)).append(" = ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" != ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" != ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" > ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" > ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" >= ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" >= ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" < ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" < ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" <= ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" <= ").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap)));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" in (").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" in (").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" not in (").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" not in (").append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    private StringBuilder nestedSelectSql(SelectDsl nestedSelect) {
        NestedMeta nestedMeta = new NestedMeta();
        nestedMeta.setSqlDialect(this.sqlDialect());
        nestedMeta.setVersion(this.version);
        nestedMeta.setDataSourceName(this.dataSourceName);
        SqlStatementSelectWrapper sqlStatementSelectWrapper = SqlUtils.executeNestedSelect(nestedMeta, nestedSelect, this.aliasTableMap);
        this.parameterBinder.addParameterBinder(sqlStatementSelectWrapper.getParameterBinder());
        return sqlStatementSelectWrapper.getRawSql();
    }

    @Override
    public <T, F> GenericWhereCondition andEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" = (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" = (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" != (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" != (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThan(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" > (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThan(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" > (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThanOrEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" >= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThanOrEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" >= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThan(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" < (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThan(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" < (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThanOrEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" <= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThanOrEqualTo(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" <= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andIn(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orIn(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotIn(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotIn(Fn<T, F> fn, SelectDsl nestedSelect) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andExists(SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(SqlUtils.getSyntaxExists(this.sqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition orExists(SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(SqlUtils.getSyntaxExists(this.sqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andNotExists(SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(" not ").append(SqlUtils.getSyntaxExists(this.sqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition orNotExists(SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(" not ").append(SqlUtils.getSyntaxExists(this.sqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andCondition(Consumer<GenericWhereCondition> nestedCondition) {
        return this.nestedCondition(nestedCondition, LogicalOperatorType.AND);
    }

    @Override
    public GenericWhereCondition orCondition(Consumer<GenericWhereCondition> nestedCondition) {
        return this.nestedCondition(nestedCondition, LogicalOperatorType.OR);
    }

    @Override
    public GenericWhereCondition andFunction(ColumFunction columFunction) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString);
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    @Override
    public GenericWhereCondition orFunction(ColumFunction columFunction) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString);
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        return this;
    }

    private GenericWhereCondition nestedCondition(Consumer<GenericWhereCondition> nestedCondition, LogicalOperatorType logicalOperatorType) {
        MysqlWhereCondition whereCondition = (MysqlWhereCondition)SqlUtils.matchDialectCondition(this.sqlDialect(), this.version, this.aliasTableMap, this.dataSourceName);
        whereCondition.setSqlExecuteType(this.sqlExecuteType);
        nestedCondition.accept(whereCondition);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType)).append(" (").append(whereCondition.getWhereConditionSyntax()).append(") ");
        this.parameterBinder.addParameterBinder(whereCondition.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andEqualTo(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" = ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition andEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" = ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public GenericWhereCondition andEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" = ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" = ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andNotEqualTo(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" != ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition andNotEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" != ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andNotEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public GenericWhereCondition andNotEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orNotEqualTo(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" != ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition orNotEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" != ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orNotEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public GenericWhereCondition orNotEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andIsNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" is null");
        return this;
    }

    @Override
    public GenericWhereCondition andIsNull(Column column) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" is null");
        return this;
    }

    @Override
    public GenericWhereCondition andIsNull(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" is null");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orIsNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" is null");
        return this;
    }

    @Override
    public GenericWhereCondition orIsNull(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" is null");
        return this;
    }

    @Override
    public GenericWhereCondition orIsNull(Column column) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" is null");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andIsNotNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" is not null");
        return this;
    }

    @Override
    public GenericWhereCondition andIsNotNull(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" is not null");
        return this;
    }

    @Override
    public GenericWhereCondition andIsNotNull(Column column) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" is not null");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orIsNotNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(this.extractQualifiedAliasToColumn(fn)).append(" is not null");
        return this;
    }

    @Override
    public GenericWhereCondition orIsNotNull(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" is not null");
        return this;
    }

    @Override
    public GenericWhereCondition orIsNotNull(Column column) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" is not null");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThan(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThan(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" > ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThan(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" > ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andGreaterThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" > ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThan(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThan(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThan(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" > ").append(key);
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThan(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" > ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orGreaterThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" > ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThan(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andGreaterThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThanOrEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" >= ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andGreaterThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" >= ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThanOrEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orGreaterThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThanOrEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" >= ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orGreaterThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" >= ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThanOrEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThan(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThan(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" < ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andLessThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition andLessThan(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThan(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThan(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" < ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orLessThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition orLessThan(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLessThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThanOrEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" <= ").append(functionToString2);
        return this;
    }

    @Override
    public GenericWhereCondition andLessThanOrEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(functionToString).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andLessThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = this.extractQualifiedAliasToColumn(field1);
        String name2 = this.extractQualifiedAliasToColumn(field2);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLessThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThanOrEqualTo(Column column, Column column2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String functionToString2 = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" <= ").append(functionToString2);
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orLessThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public GenericWhereCondition orLessThanOrEqualTo(ColumFunction columFunction, Object value) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(functionToString).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, value, this.sqlDialect()));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andIn(Fn<T, F> fn, Iterable<?> values) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" in");
        this.iteratingFnCollection(fn, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition andIn(Column column, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" in");
        this.iteratingCollection(values);
        return this;
    }

    @Override
    public GenericWhereCondition andIn(ColumFunction columFunction, Iterable<?> values) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(functionToString).append(" in");
        this.iteratingCollection(values);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orIn(Fn<T, F> fn, Iterable<?> values) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" in");
        this.iteratingFnCollection(fn, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition orIn(ColumFunction columFunction, Iterable<?> values) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(functionToString).append(" in");
        this.iteratingCollection(values);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotIn(Fn<T, F> fn, Iterable<?> values) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not in");
        this.iteratingFnCollection(fn, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition andNotIn(ColumFunction columFunction, Iterable<?> values) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(functionToString).append(" not in");
        this.iteratingCollection(values);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotIn(Fn<T, F> fn, Iterable<?> values) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not in");
        this.iteratingFnCollection(fn, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition orNotIn(ColumFunction columFunction, Iterable<?> values) {
        String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(functionToString).append(" not in");
        this.iteratingCollection(values);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andBetween(Fn<T, F> fn, Object start, Object end) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start, this.sqlDialect())).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andBetween(Column column, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition andBetween(Fn<T1, F> field1, Fn<T2, F> startField, Fn<T2, F> endField) {
        String column = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        String column2 = SqlUtils.extractQualifiedAlias(startField, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        String column3 = SqlUtils.extractQualifiedAlias(endField, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" between ").append(column2).append(" and ").append(column3);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orBetween(Fn<T, F> fn, Object start, Object end) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start, this.sqlDialect())).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orBetween(Column column, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public <T1, T2, F> GenericWhereCondition orBetween(Fn<T1, F> field1, Fn<T2, F> startField, Fn<T2, F> endField) {
        String column = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        String column2 = SqlUtils.extractQualifiedAlias(startField, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        String column3 = SqlUtils.extractQualifiedAlias(endField, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" between ").append(column2).append(" and ").append(column3);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotBetween(Fn<T, F> fn, Object start, Object end) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start, this.sqlDialect())).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andNotBetween(Column column, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotBetween(Fn<T, F> fn, Object start, Object end) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start, this.sqlDialect())).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orNotBetween(Column column, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        this.condition.append(functionToString).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andLike(Fn<T, F> fn, String pattern) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andLike(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" like ").append(key);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orLike(Fn<T, F> fn, String pattern) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orLike(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" like ").append(key);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andNotLike(Fn<T, F> fn, String pattern) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition andNotLike(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" not like ").append(key);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orNotLike(Fn<T, F> fn, String pattern) {
        String column = this.extractQualifiedAliasToColumn(fn);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern, this.sqlDialect()));
        return this;
    }

    @Override
    public GenericWhereCondition orNotLike(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" not like ").append(key);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition andMatches(Column column, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition orMatches(Column column, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition andFindInSet(Column column, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition orFindInSet(Column column, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, Object item, String separator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, Object item, String separator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition limit(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericWhereCondition limit(int limit) {
        throw new UnsupportedOperationException();
    }

    public String getWhereConditionSyntax() {
        return this.condition.toString();
    }

    public ParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }

    protected String logicalOperatorType(LogicalOperatorType logicalOperatorType) {
        return this.logicalOperatorType(logicalOperatorType, this.sqlDialect());
    }

    protected String logicalOperatorType(LogicalOperatorType logicalOperatorType, SqlDialect sqlDialect) {
        if (this.isFirstBuild) {
            this.isFirstBuild = false;
            return "";
        }
        return SqlUtils.getSyntaxLogicalOperator(logicalOperatorType, sqlDialect) + " ";
    }

    @Override
    public GenericWhereCondition andEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andNotEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andNotEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orNotEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orNotEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThan(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThan(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andGreaterThanOrEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orGreaterThanOrEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThan(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThan(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition andLessThanOrEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public GenericWhereCondition orLessThanOrEqualTo(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public GenericWhereCondition andIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" in");
        this.iteratingFnCollection(null, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition andIn(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition orIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" in");
        this.iteratingFnCollection(null, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition orIn(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andNotIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not in");
        this.iteratingFnCollection(null, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition andNotIn(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition orNotIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not in");
        this.iteratingFnCollection(null, values.iterator());
        return this;
    }

    @Override
    public GenericWhereCondition orNotIn(AggregateFunction function, SelectDsl nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public GenericWhereCondition orBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public GenericWhereCondition andNotBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public GenericWhereCondition orNotBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public GenericWhereCondition sql(String sql) {
        this.condition.append(" ").append(sql);
        return this;
    }

    protected String executeFunctionToString(AggregateFunction function) {
        return function.render(new RenderContext(this.dataSourceName, this.sqlDialect(), this.version, this.aliasTableMap));
    }

    private void iteratingCollection(Iterable<?> values) {
        this.condition.append(" (");
        Iterator<?> iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
            if (!iterator.hasNext()) continue;
            this.condition.append(", ");
        }
        this.condition.append(")");
    }

    private <T, F> void iteratingFnCollection(Fn<T, F> fn, Iterator<?> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("The parameter set cannot be empty");
        }
        this.condition.append(" (");
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value, this.sqlDialect()));
            if (!iterator.hasNext()) continue;
            this.condition.append(", ");
        }
        this.condition.append(")");
    }

    protected SqlDialect sqlDialect() {
        throw new UnsupportedOperationException("Unimplemented SQL dialects");
    }

    public void setSqlExecuteType(SqlExecuteType sqlExecuteType) {
        this.sqlExecuteType = sqlExecuteType;
    }

    <T, F> String extractQualifiedAliasToColumn(Fn<T, F> fn) {
        return SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName, this.sqlExecuteType);
    }
}

