/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.database;

import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.dml.insert.EntitiesInserter;
import com.dynamic.sql.enums.GenerationType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.GeneratedStrategy;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootExecutor {
    private static final Logger log = LoggerFactory.getLogger(RootExecutor.class);

    private RootExecutor() {
    }

    public static List<Map<String, Object>> executeQuery(Connection connection, PreparedSql preparedSql) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(preparedSql.getSql());
            List<Object> params = preparedSql.getParams();
            for (int i = 1; i <= params.size(); ++i) {
                preparedStatement.setObject(i, params.get(i - 1));
            }
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashSet<String> detectedColumnNameSet = new HashSet<String>();
            while (resultSet.next()) {
                LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    int columnType;
                    String columnName2 = metaData.getColumnLabel(i);
                    if (log.isDebugEnabled() && objectMap.containsKey(columnName2)) {
                        detectedColumnNameSet.add(columnName2);
                    }
                    Object columnValue = (columnType = metaData.getColumnType(i)) == -6 || columnType == -7 ? Integer.valueOf(resultSet.getInt(i)) : resultSet.getObject(i);
                    objectMap.put(columnName2, columnValue);
                }
                arrayList.add(objectMap);
            }
            if (log.isDebugEnabled()) {
                detectedColumnNameSet.forEach(columnName -> log.debug("Duplicate column name detected: {}", columnName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DynamicSqlException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        SqlUtils.close(resultSet, preparedStatement);
        return arrayList;
    }

    public static int executeInsert(Connection connection, PreparedSql preparedSql) {
        int rowsAffected;
        ColumnMeta columnMeta;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            resultSet = null;
            columnMeta = RootExecutor.extractAutoIncrementColumnMeta();
            preparedStatement = columnMeta == null ? connection.prepareStatement(preparedSql.getSql()) : connection.prepareStatement(preparedSql.getSql(), 1);
            List<Object> params = preparedSql.getParams();
            for (int i = 1; i <= params.size(); ++i) {
                preparedStatement.setObject(i, params.get(i - 1));
            }
            rowsAffected = preparedStatement.executeUpdate();
            if (rowsAffected > 0 && columnMeta != null) break block6;
            int n = rowsAffected;
            SqlUtils.close(resultSet, preparedStatement);
            return n;
        }
        try {
            resultSet = preparedStatement.getGeneratedKeys();
            RootExecutor.assignValueToPrimaryKey(resultSet, columnMeta);
        }
        catch (SQLException e) {
            try {
                throw new DynamicSqlException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        SqlUtils.close(resultSet, preparedStatement);
        return rowsAffected;
    }

    public static int executeUpdate(Connection connection, PreparedSql preparedSql) {
        int rowsAffected;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(preparedSql.getSql());
            List<Object> params = preparedSql.getParams();
            for (int i = 1; i <= params.size(); ++i) {
                preparedStatement.setObject(i, params.get(i - 1));
            }
            rowsAffected = preparedStatement.executeUpdate();
            if (rowsAffected <= 0) {
                int n = rowsAffected;
                return n;
            }
        }
        catch (SQLException e) {
            throw new DynamicSqlException(e);
        }
        finally {
            SqlUtils.close(null, preparedStatement);
        }
        return rowsAffected;
    }

    public static int executeInsertBatch(Connection connection, PreparedSql preparedSql) {
        int rowsAffected;
        ColumnMeta columnMeta;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            preparedStatement = null;
            resultSet = null;
            columnMeta = RootExecutor.extractAutoIncrementColumnMeta();
            preparedStatement = columnMeta == null ? connection.prepareStatement(preparedSql.getSql()) : connection.prepareStatement(preparedSql.getSql(), 1);
            List<List<Object>> batchParams = preparedSql.getBatchParams();
            for (List<Object> batchParam : batchParams) {
                for (int i = 1; i <= batchParam.size(); ++i) {
                    preparedStatement.setObject(i, batchParam.get(i - 1));
                }
                preparedStatement.addBatch();
            }
            rowsAffected = preparedStatement.executeBatch().length;
            if (rowsAffected > 0 && columnMeta != null) break block7;
            int n = rowsAffected;
            SqlUtils.close(resultSet, preparedStatement);
            return n;
        }
        try {
            resultSet = preparedStatement.getGeneratedKeys();
            RootExecutor.assignValueToPrimaryKey(resultSet, columnMeta);
        }
        catch (SQLException e) {
            try {
                throw new DynamicSqlException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        SqlUtils.close(resultSet, preparedStatement);
        return rowsAffected;
    }

    private static ColumnMeta extractAutoIncrementColumnMeta() {
        Collection<Object> localEntities = EntitiesInserter.getLocalEntities();
        if (CollectionUtils.isEmpty(localEntities)) {
            return null;
        }
        Object next = localEntities.iterator().next();
        TableMeta tableMeta = TableProvider.getTableMeta(next.getClass());
        List columnMetas = tableMeta.getColumnMetas();
        return columnMetas.stream().filter(columnMeta -> {
            GeneratedStrategy generatedStrategy = columnMeta.getGeneratedStrategy();
            return generatedStrategy != null && GenerationType.AUTO.equals((Object)generatedStrategy.getStrategy());
        }).findFirst().orElse(null);
    }

    private static void assignValueToPrimaryKey(ResultSet resultSet, ColumnMeta columnMeta) throws SQLException {
        for (Object obj : EntitiesInserter.getLocalEntities()) {
            if (!resultSet.next()) {
                return;
            }
            Long generatedKey = resultSet.getLong(1);
            Object o = ConverterUtils.convertToEntityAttribute(columnMeta, columnMeta.getField().getType(), generatedKey);
            ReflectUtils.setFieldValue(obj, columnMeta.getField(), o);
        }
    }
}

