/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.ddl;

import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.dml.delete.DeleteHandler;
import com.dynamic.sql.core.dml.insert.InsertHandler;
import com.dynamic.sql.core.dml.select.FetchResultImpl;
import com.dynamic.sql.core.dml.select.SelectHandler;
import com.dynamic.sql.core.dml.update.UpdateHandler;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.enums.DDLType;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.enums.SqlExecuteType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class SqlStatement {
    private String dataSourceName;
    private String sql;
    private ParameterBinder parameterBinder;

    public SqlStatement(String dataSourceName, String sql, ParameterBinder parameterBinder) {
        if (StringUtils.isEmpty(sql)) {
            throw new DynamicSqlException("SQL statement cannot be null or empty");
        }
        this.dataSourceName = dataSourceName;
        this.sql = sql.trim();
        this.parameterBinder = parameterBinder;
    }

    public String getSql() {
        return this.sql;
    }

    public ParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }

    public String getDataSourceName() {
        return this.dataSourceName == null ? DataSourceProvider.getDefaultDataSourceName() : this.dataSourceName;
    }

    public <T> T execute(Class<T> returnType) {
        SqlStatementWrapper sqlStatementWrapper = new SqlStatementWrapper(this.getDataSourceName(), new StringBuilder(this.sql), this.getParameterBinder());
        String sqlType = this.parseSqlType(this.sql);
        if (sqlType == null) {
            throw new DynamicSqlException("Unable to determine SQL type for statement: " + this.sql);
        }
        try {
            return this.executeSqlByType(sqlType, sqlStatementWrapper, returnType);
        }
        catch (Exception e) {
            throw new DynamicSqlException("Failed to execute SQL: " + this.sql, e);
        }
    }

    public <T, L extends List<T>> L execute(Class<T> returnType, Supplier<L> listSupplier) {
        SqlStatementWrapper sqlStatementWrapper = new SqlStatementWrapper(this.getDataSourceName(), new StringBuilder(this.sql), this.getParameterBinder());
        String sqlType = this.parseSqlType(this.sql);
        if (sqlType == null) {
            throw new DynamicSqlException("Unable to determine SQL type for statement: " + this.sql);
        }
        if (!Objects.equals(sqlType, DMLType.SELECT.name())) {
            throw new DynamicSqlException("Only accepting SQL queries: " + this.sql);
        }
        try {
            List maps = SqlExecutionFactory.executorSql(DMLType.SELECT, sqlStatementWrapper, SelectHandler::executeQuery);
            FetchResultImpl<T> tFetchResult = new FetchResultImpl<T>(returnType, maps, null);
            return tFetchResult.toList(listSupplier);
        }
        catch (Exception e) {
            throw new DynamicSqlException("Failed to execute SQL: " + this.sql, e);
        }
    }

    private String parseSqlType(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            return null;
        }
        int firstSpace = sql.indexOf(" ");
        String keyword = firstSpace > 0 ? sql.substring(0, firstSpace) : sql;
        HashMap<String, String> sqlTypeMap = new HashMap<String, String>();
        sqlTypeMap.put("SELECT", DMLType.SELECT.name());
        sqlTypeMap.put("INSERT", DMLType.INSERT.name());
        sqlTypeMap.put("UPDATE", DMLType.UPDATE.name());
        sqlTypeMap.put("DELETE", DMLType.DELETE.name());
        sqlTypeMap.put("CREATE", DDLType.CREATE.name());
        sqlTypeMap.put("ALTER", DDLType.ALTER.name());
        sqlTypeMap.put("DROP", DDLType.DROP.name());
        sqlTypeMap.put("TRUNCATE", DDLType.TRUNCATE.name());
        return sqlTypeMap.getOrDefault(keyword.toUpperCase(), DMLType.UPDATE.name());
    }

    private <T> T executeSqlByType(String sqlType, SqlStatementWrapper sqlStatementWrapper, Class<T> returnType) {
        HashMap<String, BiFunction<SqlExecuteType, SqlStatementWrapper, Object>> executorMap = new HashMap<String, BiFunction<SqlExecuteType, SqlStatementWrapper, Object>>();
        executorMap.put(DMLType.SELECT.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, SelectHandler::executeQuery));
        executorMap.put(DMLType.INSERT.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, InsertHandler::insert));
        executorMap.put(DMLType.DELETE.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, DeleteHandler::delete));
        executorMap.put(DDLType.CREATE.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, UpdateHandler::update));
        executorMap.put(DDLType.ALTER.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, UpdateHandler::update));
        executorMap.put(DDLType.DROP.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, UpdateHandler::update));
        executorMap.put(DDLType.TRUNCATE.name(), (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, UpdateHandler::update));
        SqlExecuteType executeType = this.getExecuteType(sqlType);
        BiFunction<SqlExecuteType, SqlStatementWrapper, Object> executor = executorMap.getOrDefault(sqlType, (type, wrapper) -> SqlExecutionFactory.executorSql(type, wrapper, UpdateHandler::update));
        Object apply = executor.apply(executeType, sqlStatementWrapper);
        if (apply.getClass().isAssignableFrom(returnType) || Objects.equals(returnType, Object.class)) {
            return (T)apply;
        }
        if (Objects.equals(sqlType, DMLType.SELECT.name())) {
            FetchResultImpl<T> tFetchResult = new FetchResultImpl<T>(returnType, (List)apply, null);
            return tFetchResult.toOne();
        }
        return (T)apply;
    }

    private SqlExecuteType getExecuteType(String typeName) {
        try {
            return DMLType.valueOf(typeName);
        }
        catch (IllegalArgumentException e1) {
            try {
                return DDLType.valueOf(typeName);
            }
            catch (IllegalArgumentException e2) {
                throw new DynamicSqlException("Unknown SQL type: " + typeName);
            }
        }
    }
}

