/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.delete;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.context.properties.SqlLogProperties;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.database.SqlExecutor;
import com.dynamic.sql.core.database.parser.AbstractDialectParser;
import com.dynamic.sql.core.dml.ParseWhereHandler;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitiesDeleter
extends ParseWhereHandler {
    protected static final Logger log = LoggerFactory.getLogger(EntitiesDeleter.class);
    private Class<?> entityClass;

    public <T> EntitiesDeleter(Class<T> entityClass) {
        super(null);
        this.entityClass = entityClass;
    }

    public <T> EntitiesDeleter(Class<T> entityClass, Consumer<GenericWhereCondition> condition) {
        super(condition);
        this.entityClass = entityClass;
    }

    private AbstractDialectParser getDialectParser(Collection<?> params) {
        TableMeta tableMeta = TableProvider.getTableMeta(this.entityClass);
        if (tableMeta == null) {
            throw new DynamicSqlException("Class `" + this.entityClass.getCanonicalName() + "` is not managed or cached by Dynamic-SQL, or a non-physical table has been deleted.");
        }
        String dataSourceName = tableMeta.getBindDataSourceName();
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName);
        return SqlExecutionFactory.chosenDialectParser(schemaProperties, this.entityClass, params);
    }

    public int deleteByPrimaryKey(Object pkValue, Function<SqlExecutor, Integer> doSqlExecutor) {
        AbstractDialectParser dialectParser = this.getDialectParser(Collections.singletonList(pkValue));
        dialectParser.deleteByPrimaryKey();
        return SqlExecutionFactory.executorSql(DMLType.DELETE, dialectParser.getSqlStatementWrapper(), doSqlExecutor);
    }

    public int deleteByPrimaryKey(Collection<?> pkValues, Function<SqlExecutor, Integer> doSqlExecutor) {
        AbstractDialectParser dialectParser = this.getDialectParser(pkValues);
        dialectParser.deleteByPrimaryKey();
        return SqlExecutionFactory.executorSql(DMLType.DELETE, dialectParser.getSqlStatementWrapper(), doSqlExecutor);
    }

    public int delete(Function<SqlExecutor, Integer> doSqlExecutor) {
        TableMeta tableMeta = TableProvider.getTableMeta(this.entityClass);
        if (tableMeta == null) {
            throw new DynamicSqlException("Class `" + this.entityClass.getCanonicalName() + "` is not managed or cached by Dynamic-SQL, or a non-physical table has been deleted.");
        }
        String dataSourceName = tableMeta.getBindDataSourceName();
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName);
        GenericWhereCondition whereCondition = this.applyGenericWhereCondition(schemaProperties);
        SqlLogProperties sqlLogProperties = schemaProperties.getSqlLogProperties();
        if (sqlLogProperties.isEnabled() && this.condition == null) {
            log.debug("When the Where condition is null, the data in the entire table will be deleted");
        }
        AbstractDialectParser dialectParser = SqlExecutionFactory.chosenDialectParser(schemaProperties, this.entityClass, null, whereCondition);
        dialectParser.delete();
        return SqlExecutionFactory.executorSql(DMLType.DELETE, dialectParser.getSqlStatementWrapper(), doSqlExecutor);
    }

    @Override
    public String getType() {
        return DMLType.DELETE.getType();
    }
}

