/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.insert;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.database.SqlExecutor;
import com.dynamic.sql.core.database.parser.AbstractDialectParser;
import com.dynamic.sql.core.database.parser.InsertParser;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;

public class EntitiesInserter {
    private static final ThreadLocal<Collection<Object>> LOCAL_ENTITIES = new ThreadLocal();
    private AbstractDialectParser dialectParser;
    private final Fn<?, ?>[] forcedFields;

    public EntitiesInserter(Object entity, Fn<?, ?>[] forcedFields) {
        this.forcedFields = forcedFields;
        this.setEntities(Collections.singleton(entity));
        this.init();
    }

    public EntitiesInserter(Collection<Object> entities) {
        this.forcedFields = null;
        this.setEntities(entities);
        this.init();
    }

    private void init() {
        Object next = EntitiesInserter.getLocalEntities().iterator().next();
        TableMeta tableMeta = TableProvider.getTableMeta(next.getClass());
        if (tableMeta == null) {
            throw new DynamicSqlException("Class `" + next.getClass().getCanonicalName() + "` is not managed or cached by Dynamic-SQL, or it inserts data into a non-physical table.");
        }
        String dataSourceName = tableMeta.getBindDataSourceName();
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName);
        this.dialectParser = SqlExecutionFactory.chosenDialectParser(schemaProperties, next.getClass(), EntitiesInserter.getLocalEntities());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(DMLType dmlType, Consumer<AbstractDialectParser> sqlAction, Function<SqlExecutor, Integer> doSqlExecutor) {
        try {
            sqlAction.accept(this.dialectParser);
            int n = SqlExecutionFactory.executorSql(dmlType, this.dialectParser.getSqlStatementWrapper(), doSqlExecutor);
            return n;
        }
        finally {
            this.clearEntities();
        }
    }

    public int insertSelective(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.INSERT, parser -> parser.insertSelective(this.forcedFields), doSqlExecutor);
    }

    public int insert(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.INSERT, InsertParser::insert, doSqlExecutor);
    }

    public int insertBatch(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.INSERT, InsertParser::insertBatch, doSqlExecutor);
    }

    public int insertMultiple(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.INSERT, InsertParser::insertMultiple, doSqlExecutor);
    }

    public int upsert(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.UPSERT, parser -> parser.upsert(this.forcedFields), doSqlExecutor);
    }

    public int upsertSelective(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.UPSERT, parser -> parser.upsertSelective(this.forcedFields), doSqlExecutor);
    }

    public int upsertMultiple(Function<SqlExecutor, Integer> doSqlExecutor) {
        return this.execute(DMLType.UPSERT, InsertParser::upsertMultiple, doSqlExecutor);
    }

    private void setEntities(Collection<Object> entities) {
        LOCAL_ENTITIES.set(entities);
    }

    public static Collection<Object> getLocalEntities() {
        return LOCAL_ENTITIES.get();
    }

    private void clearEntities() {
        LOCAL_ENTITIES.remove();
    }
}

