/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.dml.select.FetchResult;
import com.dynamic.sql.core.dml.select.FetchResultImpl;
import com.dynamic.sql.core.dml.select.Fetchable;
import com.dynamic.sql.core.dml.select.NestedColumnMapping;
import com.dynamic.sql.core.dml.select.SelectHandler;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.SqlUtils;
import java.util.HashMap;
import java.util.List;

public class FetchableImpl
implements Fetchable {
    private SqlStatementSelectWrapper sqlStatementSelectWrapper;
    private SelectSpecification selectSpecification;
    private NestedColumnMapping nestedColumnMapping;
    private final boolean isBuildSqlWrapper;

    public FetchableImpl(SelectSpecification selectSpecification) {
        this.isBuildSqlWrapper = true;
        this.selectSpecification = selectSpecification;
    }

    public FetchableImpl(SqlStatementSelectWrapper sqlStatementSelectWrapper) {
        this.sqlStatementSelectWrapper = sqlStatementSelectWrapper;
        this.isBuildSqlWrapper = false;
    }

    @Override
    public <R> FetchResult<R> fetch() {
        return this.fetchResult(null);
    }

    @Override
    public <T> FetchResult<T> fetch(Class<T> returnClass) {
        return this.fetchResult(returnClass);
    }

    private <T> FetchResult<T> fetchResult(Class<T> returnClass) {
        if (this.isBuildSqlWrapper) {
            SqlSelectBuilder sqlSelectBuilder = SqlUtils.matchSqlSelectBuilder(this.selectSpecification, new HashMap<String, TableAliasMapping>());
            this.sqlStatementSelectWrapper = sqlSelectBuilder.build(returnClass);
            this.nestedColumnMapping = this.selectSpecification.getNestedColumnMapping();
        }
        if (returnClass == null) {
            if (this.sqlStatementSelectWrapper.getGuessTheTargetClass() == null) {
                throw new DynamicSqlException("The query result object cannot be inferred from the context. Please declare the return type.");
            }
            returnClass = this.sqlStatementSelectWrapper.getGuessTheTargetClass();
        }
        List wrapperList = SqlExecutionFactory.executorSql(DMLType.SELECT, this.sqlStatementSelectWrapper, SelectHandler::executeQuery);
        return new FetchResultImpl<T>(returnClass, wrapperList, this.nestedColumnMapping);
    }
}

