/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.GroupFn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.select.FetchResult;
import com.dynamic.sql.core.dml.select.Fetchable;
import com.dynamic.sql.core.dml.select.FetchableImpl;
import com.dynamic.sql.core.dml.select.HavingCondition;
import com.dynamic.sql.core.dml.select.JoinCondition;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.ThenSortOrder;
import com.dynamic.sql.core.dml.select.build.LimitInfo;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.join.CrossJoin;
import com.dynamic.sql.core.dml.select.build.join.FullJoin;
import com.dynamic.sql.core.dml.select.build.join.InnerJoin;
import com.dynamic.sql.core.dml.select.build.join.LeftJoin;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.RightJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.dml.select.build.join.UnionJoin;
import com.dynamic.sql.core.dml.select.cte.CteTable;
import com.dynamic.sql.core.dml.select.order.CustomOrderBy;
import com.dynamic.sql.core.dml.select.order.DefaultOrderBy;
import com.dynamic.sql.enums.JoinTableType;
import com.dynamic.sql.enums.SortOrder;
import com.dynamic.sql.enums.UnionType;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TableRelation<R>
implements JoinCondition {
    private final SelectSpecification selectSpecification;

    public TableRelation(SelectSpecification selectSpecification) {
        this.selectSpecification = selectSpecification;
    }

    @Override
    public JoinCondition innerJoin(Class<?> clazz, Consumer<GenericWhereCondition> onCondition) {
        return this.innerJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition innerJoin(Class<?> clazz, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new InnerJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoin(SelectDsl nestedSelect, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.INNER, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new TableFunctionJoin(JoinTableType.INNER, tableFunction, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoinUnion(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.INNER, selectDsls, alias, onCondition, UnionType.UNION));
        return this;
    }

    @Override
    public JoinCondition leftJoinUnion(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.LEFT, selectDsls, alias, onCondition, UnionType.UNION));
        return this;
    }

    @Override
    public JoinCondition rightJoinUnion(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.RIGHT, selectDsls, alias, onCondition, UnionType.UNION));
        return this;
    }

    @Override
    public JoinCondition innerJoinUnionAll(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.INNER, selectDsls, alias, onCondition, UnionType.UNION_ALL));
        return this;
    }

    @Override
    public JoinCondition leftJoinUnionAll(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.LEFT, selectDsls, alias, onCondition, UnionType.UNION_ALL));
        return this;
    }

    @Override
    public JoinCondition rightJoinUnionAll(SelectDsl[] selectDsls, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new UnionJoin(JoinTableType.RIGHT, selectDsls, alias, onCondition, UnionType.UNION_ALL));
        return this;
    }

    @Override
    public JoinCondition innerJoin(CteTable cte, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition leftJoin(Class<?> clazz, Consumer<GenericWhereCondition> onCondition) {
        return this.leftJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition leftJoin(Class<?> clazz, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new LeftJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition leftJoin(SelectDsl nestedSelect, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.LEFT, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition leftJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition leftJoin(CteTable cte, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition rightJoin(Class<?> clazz, Consumer<GenericWhereCondition> onCondition) {
        return this.rightJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition rightJoin(Class<?> clazz, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new RightJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition rightJoin(SelectDsl nestedSelect, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.RIGHT, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition rightJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition rightJoin(CteTable cte, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition fullJoin(Class<?> clazz, Consumer<GenericWhereCondition> onCondition) {
        return this.fullJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition fullJoin(Class<?> clazz, String alias, Consumer<GenericWhereCondition> onCondition) {
        this.selectSpecification.getJoinTables().add(new FullJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition fullJoin(CteTable cte, Consumer<GenericWhereCondition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition crossJoin(Class<?> clazz) {
        this.selectSpecification.getJoinTables().add(new CrossJoin(clazz));
        return this;
    }

    @Override
    public JoinCondition crossJoin(CteTable cte) {
        this.selectSpecification.getJoinTables().add(new CrossJoin(cte));
        return this;
    }

    public TableRelation<R> where(Consumer<GenericWhereCondition> condition) {
        this.selectSpecification.setWhereCondition(condition);
        return this;
    }

    public TableRelation<R> where(boolean isEffective, Consumer<GenericWhereCondition> condition) {
        return isEffective ? this.where(condition) : this;
    }

    @Override
    public Fetchable limit(int offset, int limit) {
        this.selectSpecification.setLimitInfo(new LimitInfo(offset, limit));
        return this;
    }

    @Override
    public Fetchable limit(boolean isEffective, int offset, int limit) {
        return isEffective ? this.limit(offset, limit) : this;
    }

    @Override
    public Fetchable limit(int limit) {
        this.selectSpecification.setLimitInfo(new LimitInfo(null, limit));
        return this;
    }

    @Override
    public Fetchable limit(boolean isEffective, int limit) {
        return isEffective ? this.limit(limit) : this;
    }

    public TableRelation<R> where() {
        return this;
    }

    @Override
    public FetchResult<R> fetch() {
        FetchableImpl fetchable = new FetchableImpl(this.selectSpecification);
        return fetchable.fetch();
    }

    @Override
    public <T> FetchResult<T> fetch(Class<T> returnClass) {
        FetchableImpl fetchable = new FetchableImpl(this.selectSpecification);
        return fetchable.fetch(returnClass);
    }

    @SafeVarargs
    public final <T> TableRelation<R> groupBy(FieldFn<T, ?> ... fnKey) {
        if (fnKey == null) {
            return this;
        }
        for (FieldFn<T, ?> tkFn : fnKey) {
            this.selectSpecification.getGroupByObject().getGroupByList().add(tkFn);
        }
        return this;
    }

    @SafeVarargs
    public final <T> TableRelation<R> groupBy(boolean isEffective, FieldFn<T, ?> ... fnKey) {
        return isEffective ? this.groupBy(fnKey) : this;
    }

    public final TableRelation<R> groupBy(String tableAlias, String columnName) {
        this.selectSpecification.getGroupByObject().getGroupByList().add(new GroupFn(tableAlias, columnName));
        return this;
    }

    public final TableRelation<R> groupBy(boolean isEffective, String tableAlias, String columnName) {
        return isEffective ? this.groupBy(tableAlias, columnName) : this;
    }

    public final <T> TableRelation<R> groupBy(String tableAlias, FieldFn<T, ?> fn) {
        this.selectSpecification.getGroupByObject().getGroupByList().add(new GroupFn(tableAlias, fn));
        return this;
    }

    public final <T> TableRelation<R> groupBy(boolean isEffective, String tableAlias, FieldFn<T, ?> fn) {
        return isEffective ? this.groupBy(tableAlias, fn) : this;
    }

    public final TableRelation<R> groupBy(GroupFn ... groupByFn) {
        this.selectSpecification.getGroupByObject().getGroupByList().addAll(Arrays.asList(groupByFn));
        return this;
    }

    public final TableRelation<R> groupBy(boolean isEffective, GroupFn ... groupByFn) {
        return isEffective ? this.groupBy(groupByFn) : this;
    }

    public final TableRelation<R> groupBy(ColumFunction ... columFunction) {
        this.selectSpecification.getGroupByObject().getGroupByList().addAll(Arrays.asList(columFunction));
        return this;
    }

    public final TableRelation<R> groupBy(boolean isEffective, ColumFunction ... columFunction) {
        return isEffective ? this.groupBy(columFunction) : this;
    }

    public TableRelation<R> having(Consumer<HavingCondition<GenericWhereCondition>> condition) {
        this.selectSpecification.setHavingCondition(condition);
        return this;
    }

    public TableRelation<R> having(boolean isEffective, Consumer<HavingCondition<GenericWhereCondition>> condition) {
        return isEffective ? this.having(condition) : this;
    }

    public <T, F> ThenSortOrder<R> orderBy(FieldFn<T, F> field) {
        return this.orderBy(true, field, SortOrder.ASC);
    }

    public <T, F> ThenSortOrder<R> orderBy(boolean condition, FieldFn<T, F> field) {
        return this.orderBy(condition, field, SortOrder.ASC);
    }

    public <T, F> ThenSortOrder<R> orderBy(FieldFn<T, F> field, SortOrder sortOrder) {
        return this.orderBy(true, field, sortOrder);
    }

    public <T, F> ThenSortOrder<R> orderBy(boolean condition, FieldFn<T, F> field, SortOrder sortOrder) {
        return this.orderBy(condition, null, field, sortOrder);
    }

    public <T, F> ThenSortOrder<R> orderBy(String tableAlias, FieldFn<T, F> field) {
        return this.orderBy(true, tableAlias, field, SortOrder.ASC);
    }

    public <T, F> ThenSortOrder<R> orderBy(boolean condition, String tableAlias, FieldFn<T, F> field) {
        return this.orderBy(condition, tableAlias, field, SortOrder.ASC);
    }

    public <T, F> ThenSortOrder<R> orderBy(String tableAlias, FieldFn<T, F> field, SortOrder sortOrder) {
        return this.orderBy(true, tableAlias, field, sortOrder);
    }

    public <T, F> ThenSortOrder<R> orderBy(boolean condition, String tableAlias, FieldFn<T, F> field, SortOrder sortOrder) {
        return new ThenSortOrder(condition, this, new DefaultOrderBy(tableAlias, field, sortOrder));
    }

    public ThenSortOrder<R> orderBy(String tableAlias, String columnName) {
        return this.orderBy(true, tableAlias, columnName, SortOrder.ASC);
    }

    public ThenSortOrder<R> orderBy(boolean condition, String tableAlias, String columnName) {
        return this.orderBy(condition, tableAlias, columnName, SortOrder.ASC);
    }

    public ThenSortOrder<R> orderBy(String columnName, SortOrder sortOrder) {
        return this.orderBy(true, null, columnName, sortOrder);
    }

    public ThenSortOrder<R> orderBy(boolean condition, String columnName, SortOrder sortOrder) {
        return this.orderBy(condition, null, columnName, sortOrder);
    }

    public ThenSortOrder<R> orderBy(String tableAlias, String columnName, SortOrder sortOrder) {
        return this.orderBy(true, tableAlias, columnName, sortOrder);
    }

    public ThenSortOrder<R> orderBy(boolean condition, String tableAlias, String columnName, SortOrder sortOrder) {
        return new ThenSortOrder(condition, this, new DefaultOrderBy(tableAlias, columnName, sortOrder));
    }

    public ThenSortOrder<R> orderBy(String orderingFragment) {
        return this.orderBy(true, orderingFragment);
    }

    public ThenSortOrder<R> orderBy(AbstractColumFunction iColumFunction) {
        return this.orderBy(iColumFunction, SortOrder.ASC);
    }

    public ThenSortOrder<R> orderBy(boolean condition, AbstractColumFunction iColumFunction) {
        return this.orderBy(condition, iColumFunction, SortOrder.ASC);
    }

    public ThenSortOrder<R> orderBy(AbstractColumFunction iColumFunction, SortOrder sortOrder) {
        return this.orderBy(true, iColumFunction, sortOrder);
    }

    public ThenSortOrder<R> orderBy(boolean condition, AbstractColumFunction iColumFunction, SortOrder sortOrder) {
        return new ThenSortOrder(condition, this, new DefaultOrderBy(iColumFunction, sortOrder));
    }

    public ThenSortOrder<R> orderBy(boolean condition, String orderingFragment) {
        return new ThenSortOrder(condition, this, new CustomOrderBy(orderingFragment));
    }

    protected SelectSpecification getSelectSpecification() {
        return this.selectSpecification;
    }
}

