/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.dml.select.AbstractUnion;
import com.dynamic.sql.core.dml.select.FetchResult;
import com.dynamic.sql.core.dml.select.FetchResultImpl;
import com.dynamic.sql.core.dml.select.NestedMeta;
import com.dynamic.sql.core.dml.select.Select;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.SelectHandler;
import com.dynamic.sql.core.dml.select.TableRelation;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.enums.UnionType;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.SqlUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.HashMap;
import java.util.List;

public class UnionSelect
extends AbstractUnion {
    private final StringBuilder rawSql = new StringBuilder();
    private final ParameterBinder parameterBinder = new ParameterBinder();
    private final UnionType unionType;
    private NestedMeta nestedMeta;

    public UnionSelect(UnionType unionType) {
        super(new TableRelation<Object>(new SelectSpecification()));
        this.unionType = unionType;
    }

    public void parseSelectDsls(SelectDsl[] selects) {
        String dataSourceName = null;
        SqlDialect sqlDialect = null;
        Version version = null;
        for (int i = 0; i < selects.length; ++i) {
            SelectDsl selectDsl = selects[i];
            this.rawSql.append("( ");
            Select select = new Select(null);
            AbstractColumnReference columnReference = select.loadColumReference();
            selectDsl.accept(columnReference);
            SqlSelectBuilder sqlSelectBuilder = SqlUtils.matchSqlSelectBuilder(select.getSelectSpecification(), new HashMap<String, TableAliasMapping>());
            if (StringUtils.isEmpty(dataSourceName)) {
                dataSourceName = sqlSelectBuilder.getDataSourceName();
            }
            if (sqlDialect == null) {
                sqlDialect = sqlSelectBuilder.getSqlDialect();
            }
            if (version == null) {
                version = sqlSelectBuilder.getVersion();
            }
            SqlStatementSelectWrapper build = sqlSelectBuilder.build(null);
            this.parameterBinder.addParameterBinder(build.getParameterBinder());
            this.rawSql.append((CharSequence)build.getRawSql());
            this.rawSql.append(") ");
            if (i >= selects.length - 1) continue;
            this.rawSql.append(SqlUtils.getSyntaxUnion(sqlDialect, this.unionType)).append(" ");
        }
        this.nestedMeta = new NestedMeta();
        this.nestedMeta.setVersion(version);
        this.nestedMeta.setSqlDialect(sqlDialect);
        this.nestedMeta.setDataSourceName(dataSourceName);
    }

    @Override
    public FetchResult<Object> fetch() {
        throw new UnsupportedOperationException("UnionSelect does not support fetch() without specifying return type. Please use fetch(Class<T> returnClass) instead.");
    }

    @Override
    public <T> FetchResult<T> fetch(Class<T> returnClass) {
        if (returnClass == null) {
            throw new NullPointerException("returnClass is null");
        }
        TableRelation tableRelation = this.getTableRelation();
        SelectSpecification selectSpecification = tableRelation.getSelectSpecification();
        if (CollectionUtils.isNotEmpty(selectSpecification.getOrderBys())) {
            selectSpecification.setNestedMeta(this.nestedMeta);
            HashMap<String, TableAliasMapping> tableAliasMappingHashMap = new HashMap<String, TableAliasMapping>();
            tableAliasMappingHashMap.put("***", new TableAliasMapping(null, true));
            SqlSelectBuilder sqlSelectBuilder = SqlUtils.matchSqlSelectBuilder(selectSpecification, tableAliasMappingHashMap);
            sqlSelectBuilder.setIsFromNestedSelect(true);
            this.rawSql.append(sqlSelectBuilder.parseOrderBy(selectSpecification.getOrderBys(), returnClass));
            SqlStatementSelectWrapper build = sqlSelectBuilder.build(returnClass);
            this.parameterBinder.addParameterBinder(build.getParameterBinder());
        }
        if (selectSpecification.getLimitInfo() != null) {
            SqlSelectBuilder sqlSelectBuilder = SqlUtils.matchSqlSelectBuilder(selectSpecification, null);
            this.rawSql.append(sqlSelectBuilder.parseLimit());
            SqlStatementSelectWrapper build = sqlSelectBuilder.build(returnClass);
            this.parameterBinder.addParameterBinder(build.getParameterBinder());
        }
        SqlStatementSelectWrapper unionSqlStatementSelectWrapper = new SqlStatementSelectWrapper(this.nestedMeta.getDataSourceName(), this.rawSql, this.parameterBinder, returnClass);
        List wrapperList = SqlExecutionFactory.executorSql(DMLType.SELECT, unionSqlStatementSelectWrapper, SelectHandler::executeQuery);
        return new FetchResultImpl<T>(returnClass, wrapperList, null);
    }

    public String getRawSql() {
        return this.rawSql.toString();
    }

    public ParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }
}

