/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select.build;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.AbstractAliasHelper;
import com.dynamic.sql.core.column.ColumnModifiers;
import com.dynamic.sql.core.column.conventional.AllColumn;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.conventional.NumberColumn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.column.function.windows.Over;
import com.dynamic.sql.core.column.function.windows.aggregate.Count;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.UnionSelect;
import com.dynamic.sql.core.dml.select.build.LimitInfo;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.column.ColumnQuery;
import com.dynamic.sql.core.dml.select.build.column.ColumnWrapper;
import com.dynamic.sql.core.dml.select.build.column.NestedColumn;
import com.dynamic.sql.core.dml.select.build.column.StringColumn;
import com.dynamic.sql.core.dml.select.build.join.FromJoin;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.FromUnionJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.dml.select.build.join.UnionJoin;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.Arithmetic;
import com.dynamic.sql.model.Dual;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.MapUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.SqlUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class GenericSqlSelectBuilder
extends SqlSelectBuilder {
    public GenericSqlSelectBuilder(SelectSpecification selectSpecification, Map<String, TableAliasMapping> aliasTableMap) {
        super(selectSpecification);
        if (MapUtils.isNotEmpty(aliasTableMap)) {
            aliasTableMap.forEach(this.aliasTableMap::putIfAbsent);
        }
    }

    @Override
    protected void parseColumnFunction() {
        String selectStr = SqlUtils.getSyntaxSelect(this.sqlDialect).concat(" ");
        this.sqlBuilder.append(selectStr);
        for (int i = 0; i < this.selectSpecification.getColumFunctions().size(); ++i) {
            ColumnQuery columnQuery = this.selectSpecification.getColumFunctions().get(i);
            String columnSeparator = ", ";
            if (this.isIgnoreColumn(columnQuery)) {
                if (!StringUtils.endsWith(this.sqlBuilder.toString(), ", ")) continue;
                this.sqlBuilder.delete(this.sqlBuilder.length() - columnSeparator.length(), this.sqlBuilder.length());
                continue;
            }
            if (this.selectSpecification.getColumFunctions().size() - 1 == i) {
                columnSeparator = "";
            }
            if (columnQuery instanceof ColumFunction) {
                ColumFunction columFunction = (ColumFunction)((Object)columnQuery);
                String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap));
                this.sqlBuilder.append(functionToString);
                continue;
            }
            if (columnQuery instanceof StringColumn) {
                StringColumn stringColumn = (StringColumn)columnQuery;
                this.sqlBuilder.append(" ").append(stringColumn.getSql()).append(" ");
                continue;
            }
            if (columnQuery instanceof ColumnWrapper) {
                ColumnWrapper columnWrapper = (ColumnWrapper)columnQuery;
                ColumFunction columFunction = columnWrapper.getColumFunction();
                if (columFunction instanceof AllColumn) {
                    this.parseAllColumn((AllColumn)columFunction);
                    this.sqlBuilder.append(columnSeparator);
                    continue;
                }
                StringBuilder arithmeticSql = new StringBuilder();
                ParameterBinder arithmeticParameterBinder = null;
                if (columFunction instanceof AbstractColumFunction) {
                    AbstractColumFunction abstractColumFunction = (AbstractColumFunction)columFunction;
                    abstractColumFunction.setAliasTableMap(this.aliasTableMap);
                    abstractColumFunction.setDataSourceName(this.dataSourceName);
                    Arithmetic arithmetic = abstractColumFunction.getArithmetic();
                    arithmeticSql.append((CharSequence)arithmetic.getArithmeticSql());
                    arithmeticParameterBinder = arithmetic.getArithmeticParameterBinder();
                    this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
                }
                if (columFunction instanceof NumberColumn || columFunction instanceof Count) {
                    this.sqlBuilder.append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap))).append((CharSequence)arithmeticSql);
                    this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
                    String columnAlias = StringUtils.isEmpty(columnQuery.getAlias()) ? "" : this.syntaxAs() + SqlUtils.quoteIdentifier(this.sqlDialect, columnQuery.getAlias());
                    this.sqlBuilder.append(columnAlias).append(columnSeparator);
                    continue;
                }
                Fn<?, ?> fn = columFunction.originColumn();
                if (columFunction instanceof AbstractAliasHelper) {
                    this.sqlBuilder.append(columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap))).append((CharSequence)arithmeticSql);
                    this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
                    if (StringUtils.isNotBlank(columnQuery.getAlias())) {
                        this.sqlBuilder.append(this.syntaxAs()).append(columnQuery.getAlias());
                    }
                    this.sqlBuilder.append(columnSeparator);
                    continue;
                }
                String tableAlias = columFunction.getTableAlias();
                if (tableAlias == null) {
                    tableAlias = ((TableAliasMapping)this.aliasTableMap.get(ReflectUtils.getOriginalClassCanonicalName(fn))).getAlias();
                }
                columFunction.setTableAlias(tableAlias);
                String functionToString = columFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap));
                String columnAlias = columnQuery.getAlias();
                if (StringUtils.isEmpty(columnAlias) && Objects.nonNull(columFunction.originColumn())) {
                    columnAlias = ReflectUtils.fnToFieldName(columFunction.originColumn());
                    columnAlias = SqlUtils.quoteIdentifier(this.sqlDialect, columnAlias);
                }
                columnAlias = StringUtils.isEmpty(columnAlias) ? "" : this.syntaxAs() + columnAlias;
                this.sqlBuilder.append(functionToString).append((CharSequence)arithmeticSql);
                Consumer<Over> overConsumer = columnWrapper.getOver();
                if (overConsumer != null) {
                    Over over = new Over();
                    overConsumer.accept(over);
                    String parseOrderBy = this.parseOrderBy(over.getOrderByList(), null);
                    over.setOverClause(parseOrderBy);
                    this.sqlBuilder.append(" ").append(over.toOverString(this.sqlDialect));
                }
                this.sqlBuilder.append(columnAlias);
                if (columFunction instanceof ColumnModifiers) {
                    ColumnModifiers columnModifiers = (ColumnModifiers)((Object)columFunction);
                    if (columnModifiers.shouldAppendDelimiter()) {
                        this.sqlBuilder.append(columnSeparator);
                    } else {
                        this.sqlBuilder.append(" ");
                    }
                } else {
                    this.sqlBuilder.append(columnSeparator);
                }
                this.parameterBinder.addParameterBinder(columFunction.parameterBinder());
                this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
            }
            if (!(columnQuery instanceof NestedColumn)) continue;
            NestedColumn nestedColumn = (NestedColumn)columnQuery;
            SelectDsl nestedColumnReference = nestedColumn.getNestedColumnReference();
            SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedColumnReference);
            String columnAliasString = this.syntaxAs() + SqlUtils.quoteIdentifier(this.sqlDialect, columnQuery.getAlias());
            this.sqlBuilder.append("(").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")").append(columnAliasString).append(columnSeparator);
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        }
    }

    protected boolean isIgnoreColumn(ColumnQuery columnQuery) {
        if (this.selectSpecification.getIgnoreColumFunctions().isEmpty()) {
            return false;
        }
        if (!(columnQuery instanceof ColumnWrapper)) {
            return false;
        }
        ColumnWrapper columnWrapper = (ColumnWrapper)columnQuery;
        if (!(columnWrapper.getColumFunction() instanceof Column)) {
            return false;
        }
        Column column = (Column)columnWrapper.getColumFunction();
        for (ColumnQuery columFunction : this.selectSpecification.getIgnoreColumFunctions()) {
            String field;
            String ignoreField;
            String className;
            ColumnWrapper ignoreColumnWrapper = (ColumnWrapper)columFunction;
            Column ignoreColumn = (Column)ignoreColumnWrapper.getColumFunction();
            String ignoreClassName = ReflectUtils.getOriginalClassCanonicalName(ignoreColumn.originColumn());
            if (!Objects.equals(ignoreClassName, className = ReflectUtils.getOriginalClassCanonicalName(column.originColumn())) || !Objects.equals(ignoreField = ReflectUtils.fnToFieldName(ignoreColumn.originColumn()), field = ReflectUtils.fnToFieldName(column.originColumn()))) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnoreColumn(String tableClasspath, ColumnMeta columnMeta) {
        if (this.selectSpecification.getIgnoreColumFunctions().isEmpty()) {
            return false;
        }
        for (ColumnQuery columFunction : this.selectSpecification.getIgnoreColumFunctions()) {
            String ignoreField;
            ColumnWrapper ignoreColumnWrapper = (ColumnWrapper)columFunction;
            Column ignoreColumn = (Column)ignoreColumnWrapper.getColumFunction();
            String ignoreClassName = ReflectUtils.getOriginalClassCanonicalName(ignoreColumn.originColumn());
            if (!Objects.equals(ignoreClassName, tableClasspath) || !Objects.equals(ignoreField = ReflectUtils.fnToFieldName(ignoreColumn.originColumn()), columnMeta.getField().getName())) continue;
            return true;
        }
        return false;
    }

    protected String automaticallySelectAliases(JoinTable joinTable) {
        Class<?> tableClass = joinTable.getTableClass();
        TableMeta tableMeta = TableProvider.getTableMeta(tableClass);
        if (tableClass == Dual.class) {
            return tableMeta.getTableName();
        }
        if (tableMeta == null) {
            throw new DynamicSqlException("Cannot find table mapping for class: " + tableClass.getCanonicalName());
        }
        String alias = StringUtils.isEmpty(joinTable.getTableAlias()) ? tableMeta.getTableAlias() : joinTable.getTableAlias();
        String tableAlias = SqlUtils.quoteIdentifier(this.sqlDialect, alias);
        return this.getSchemaTableFullName(tableMeta).concat(this.syntaxAs()).concat(tableAlias);
    }

    @Override
    protected boolean parseFormTables() {
        List<JoinTable> joinTables = this.selectSpecification.getJoinTables();
        for (JoinTable joinTable : joinTables) {
            this.parseJoinTable(joinTable);
        }
        return true;
    }

    protected void parseJoinTable(JoinTable joinTable) {
        if (joinTable instanceof FromNestedJoin) {
            FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
            NestedJoin nestedJoin = fromNestedJoin.getNestedJoin();
            SqlStatementSelectWrapper sqlStatementWrapper = this.parseNestedJoinSqlStatementWrapper(nestedJoin);
            this.sqlBuilder.append(" (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(") ").append(this.syntaxAs()).append(nestedJoin.getTableAlias());
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
            return;
        }
        if (joinTable instanceof FromUnionJoin) {
            FromUnionJoin fromUnionJoin = (FromUnionJoin)joinTable;
            UnionJoin unionJoin = fromUnionJoin.getUnionJoin();
            UnionSelect unionSelect = new UnionSelect(unionJoin.getUnionType());
            unionSelect.parseSelectDsls(unionJoin.getNestedSelects());
            this.sqlBuilder.append(" (").append(unionSelect.getRawSql()).append(") ").append(this.syntaxAs()).append(fromUnionJoin.getTableAlias());
            this.parameterBinder.addParameterBinder(unionSelect.getParameterBinder());
            return;
        }
        if (joinTable instanceof FromJoin) {
            if (joinTable.getTableFunction() != null) {
                TableFunction tableFunction = joinTable.getTableFunction().get();
                if (tableFunction instanceof Column) {
                    Column column = (Column)tableFunction;
                    column.setDataSourceName(this.dataSourceName);
                }
                this.sqlBuilder.append(tableFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap))).append(this.syntaxAs()).append(joinTable.getTableAlias());
                return;
            }
            this.sqlBuilder.append(this.automaticallySelectAliases(joinTable));
            return;
        }
        String syntaxJoin = " " + SqlUtils.getSyntaxJoin(this.sqlDialect, joinTable.getJoinTableType()) + " ";
        if (joinTable instanceof NestedJoin) {
            NestedJoin nestedJoin = (NestedJoin)joinTable;
            SqlStatementSelectWrapper sqlStatementWrapper = this.parseNestedJoinSqlStatementWrapper(nestedJoin);
            this.sqlBuilder.append(" ").append(syntaxJoin).append(" (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(") ").append(this.syntaxAs()).append(SqlUtils.quoteIdentifier(this.sqlDialect, nestedJoin.getTableAlias()));
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
            this.appendOnCondition(joinTable);
            return;
        }
        if (joinTable instanceof TableFunctionJoin) {
            TableFunctionJoin tableFunctionJoin = (TableFunctionJoin)joinTable;
            TableFunction tableFunction = tableFunctionJoin.getTableFunction().get();
            String functionToString = tableFunction.render(new RenderContext(this.dataSourceName, this.sqlDialect, this.version, this.aliasTableMap));
            this.sqlBuilder.append(" ").append(syntaxJoin).append(functionToString).append(this.syntaxAs()).append(SqlUtils.quoteIdentifier(this.sqlDialect, tableFunctionJoin.getTableAlias()));
            this.parameterBinder.addParameterBinder(tableFunction.parameterBinder());
            this.appendOnCondition(joinTable);
            return;
        }
        if (joinTable instanceof UnionJoin) {
            UnionJoin unionJoin = (UnionJoin)joinTable;
            UnionSelect unionSelect = new UnionSelect(unionJoin.getUnionType());
            unionSelect.parseSelectDsls(unionJoin.getNestedSelects());
            this.sqlBuilder.append(" ").append(syntaxJoin).append(" (").append(unionSelect.getRawSql()).append(") ").append(this.syntaxAs()).append(SqlUtils.quoteIdentifier(this.sqlDialect, unionJoin.getTableAlias()));
            this.parameterBinder.addParameterBinder(unionSelect.getParameterBinder());
            this.appendOnCondition(joinTable);
            return;
        }
        this.sqlBuilder.append(syntaxJoin).append(this.automaticallySelectAliases(joinTable));
        this.appendOnCondition(joinTable);
    }

    private void appendOnCondition(JoinTable joinTable) {
        Consumer<GenericWhereCondition> onCondition = joinTable.getOnCondition();
        if (onCondition != null) {
            String syntaxOn = " " + SqlUtils.getSyntaxOn(this.sqlDialect) + " ";
            Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
            onCondition.accept((GenericWhereCondition)whereCondition);
            this.parameterBinder.addParameterBinder(((GenericWhereCondition)whereCondition).getParameterBinder());
            this.sqlBuilder.append(syntaxOn).append(((GenericWhereCondition)whereCondition).getWhereConditionSyntax());
        }
    }

    private SqlStatementSelectWrapper parseNestedJoinSqlStatementWrapper(NestedJoin nestedJoin) {
        SqlStatementSelectWrapper sqlStatementWrapper = nestedJoin.getSqlStatementWrapper();
        if (sqlStatementWrapper == null) {
            sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedJoin.getNestedSelect());
        }
        return sqlStatementWrapper;
    }

    @Override
    public String parseLimit() {
        StringBuilder stringBuilder = new StringBuilder();
        LimitInfo limitInfo = this.selectSpecification.getLimitInfo();
        if (limitInfo == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append(" ").append(SqlUtils.getSyntaxLimit(SqlDialect.MYSQL)).append(" ");
        if (limitInfo.getOffset() != null) {
            stringBuilder.append(SqlUtils.registerValueWithKey(this.parameterBinder, limitInfo.getOffset())).append(", ");
        }
        stringBuilder.append(SqlUtils.registerValueWithKey(this.parameterBinder, limitInfo.getLimit()));
        return stringBuilder.toString();
    }

    private void parseAllColumn(AllColumn allColumn) {
        String tableAlias = allColumn.getTableAlias();
        if (StringUtils.isNotEmpty(tableAlias)) {
            String[] clazz = new String[1];
            this.aliasTableMap.forEach((cls, alias) -> {
                if (alias == null) {
                    return;
                }
                if (alias.equals(tableAlias)) {
                    clazz[0] = cls;
                }
            });
            if (clazz[0] == null || clazz[0].equals(tableAlias)) {
                this.sqlBuilder.append(tableAlias).append(".*");
                return;
            }
            List<ColumnMeta> columnMetas = TableProvider.getTableMeta(clazz[0]).getColumnMetas();
            this.appendQueryColumn(columnMetas, tableAlias, clazz[0]);
            return;
        }
        Class<?> tableClass = allColumn.getTableClass();
        if (tableClass != null) {
            this.appendQueryAllColumnForClass(tableClass);
            return;
        }
        JoinTable joinTable = this.selectSpecification.getJoinTables().get(0);
        if (joinTable instanceof UnionJoin) {
            if (tableAlias != null) {
                this.sqlBuilder.append(tableAlias).append(".");
            }
            this.sqlBuilder.append("*");
            return;
        }
        AtomicInteger cursor = new AtomicInteger();
        this.aliasTableMap.forEach((cls, alias) -> {
            if (cursor.getAndIncrement() != 0) {
                this.sqlBuilder.append(", ");
            }
            this.appendQueryAllColumnForClass((String)cls);
        });
    }

    private void appendQueryAllColumnForClass(Class<?> tableClass) {
        this.appendQueryAllColumnForClass(tableClass.getCanonicalName());
    }

    private void appendQueryAllColumnForClass(String canonicalName) {
        TableMeta tableMeta;
        try {
            tableMeta = TableProvider.getTableMeta(canonicalName);
        }
        catch (RuntimeException e) {
            tableMeta = null;
        }
        if (tableMeta == null) {
            this.sqlBuilder.append(canonicalName).append(".*");
            return;
        }
        if (this.aliasTableMap.get(canonicalName) == null) {
            this.sqlBuilder.append("*");
            return;
        }
        String tableAlias = ((TableAliasMapping)this.aliasTableMap.get(canonicalName)).getAlias();
        tableAlias = tableAlias == null ? tableMeta.getTableAlias() : tableAlias;
        List<ColumnMeta> columnMetas = tableMeta.getColumnMetas();
        this.appendQueryColumn(columnMetas, tableAlias, canonicalName);
    }

    private void appendQueryColumn(List<ColumnMeta> columnMetas, String tableAlias, String tableClasspath) {
        for (int i = 0; i < columnMetas.size(); ++i) {
            ColumnMeta columnMeta = columnMetas.get(i);
            if (this.isIgnoreColumn(tableClasspath, columnMeta)) continue;
            this.sqlBuilder.append(SqlUtils.quoteIdentifier(this.sqlDialect, tableAlias)).append(".").append(SqlUtils.quoteIdentifier(this.sqlDialect, columnMeta.getColumnName())).append(" ").append(SqlUtils.getSyntaxAs(this.sqlDialect)).append(" ").append(SqlUtils.quoteIdentifier(this.sqlDialect, columnMeta.getField().getName()));
            if (columnMetas.size() - 1 <= i) continue;
            this.sqlBuilder.append(", ");
        }
    }
}

