/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select.build;

import com.dynamic.sql.core.dml.select.build.GenericSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.join.FullJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.LeftJoin;
import com.dynamic.sql.core.dml.select.build.join.RightJoin;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.TableAliasMapping;
import java.util.List;
import java.util.Map;

public class MysqlSqlSelectBuilder
extends GenericSqlSelectBuilder {
    public MysqlSqlSelectBuilder(SelectSpecification selectSpecification, Map<String, TableAliasMapping> aliasTableMap) {
        super(selectSpecification, aliasTableMap);
    }

    @Override
    protected boolean parseFormTables() {
        RightJoin rightJoin;
        LeftJoin leftJoin;
        List<JoinTable> joinTables = this.selectSpecification.getJoinTables();
        if (joinTables.stream().noneMatch(FullJoin.class::isInstance)) {
            super.parseFormTables();
            return true;
        }
        if (joinTables.size() != 2) {
            throw new DynamicSqlException("MySQL full join only supports two tables.");
        }
        this.parseJoinTable(joinTables.get(0));
        JoinTable joinTable = joinTables.get(1);
        StringBuilder stubSql = new StringBuilder(this.sqlBuilder);
        if (joinTable.getTableClass() != null) {
            leftJoin = new LeftJoin(joinTable.getTableClass(), joinTable.getTableAlias(), joinTable.getOnCondition());
            rightJoin = new RightJoin(joinTable.getTableClass(), joinTable.getTableAlias(), joinTable.getOnCondition());
        } else {
            leftJoin = new LeftJoin(joinTable.getCteTable(), joinTable.getOnCondition());
            rightJoin = new RightJoin(joinTable.getCteTable(), joinTable.getOnCondition());
        }
        this.parseJoinTable(leftJoin);
        this.continueParsingSql(null);
        StringBuilder leftSql = new StringBuilder(this.sqlBuilder);
        this.sqlBuilder.setLength(0);
        StringBuilder rightSql = new StringBuilder(stubSql);
        this.parseJoinTable(rightJoin);
        this.continueParsingSql(null);
        rightSql.append((CharSequence)this.sqlBuilder);
        leftSql.append(" union ").append((CharSequence)rightSql);
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append((CharSequence)leftSql);
        return false;
    }
}

