/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.datasource;

import com.dynamic.sql.datasource.DataSourceMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProvider.class);
    private static final Map<String, DataSourceMeta> DATA_SOURCE_META_MAP = new ConcurrentHashMap<String, DataSourceMeta>();

    private DataSourceProvider() {
    }

    public static DataSourceMeta getDataSourceMeta(String dataSourceName) {
        if (DATA_SOURCE_META_MAP.isEmpty() || dataSourceName == null) {
            return null;
        }
        return DATA_SOURCE_META_MAP.get(dataSourceName);
    }

    public static List<String> getDataSourceNameList() {
        if (DATA_SOURCE_META_MAP.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(DATA_SOURCE_META_MAP.keySet());
    }

    public static List<DataSourceMeta> getDataSourceMetaList() {
        if (DATA_SOURCE_META_MAP.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<DataSourceMeta>(DATA_SOURCE_META_MAP.values());
    }

    public static String getDataSourceName(DataSourceMeta dataSourceMeta) {
        if (DATA_SOURCE_META_MAP.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, DataSourceMeta> entry : DATA_SOURCE_META_MAP.entrySet()) {
            if (!entry.getValue().equals(dataSourceMeta)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected static synchronized void saveDataSourceMeta(String dataSourceName, DataSourceMeta dataSourceMeta) {
        DataSourceProvider.saveDataSourceMeta(false, dataSourceName, dataSourceMeta);
    }

    protected static synchronized void saveDataSourceMeta(boolean allowDataSourceDefinitionOverriding, String dataSourceName, DataSourceMeta dataSourceMeta) {
        DataSourceMeta defaultDataSourceMeta;
        if (dataSourceMeta == null) {
            throw new NullPointerException("dataSourceMeta is null");
        }
        DataSourceMeta exists = DataSourceProvider.getDataSourceMeta(dataSourceName);
        if (exists != null) {
            if (allowDataSourceDefinitionOverriding) {
                log.info("Override data source: {}", (Object)dataSourceName);
            } else {
                throw new IllegalArgumentException("Duplicate datasource name: " + dataSourceName);
            }
        }
        if (dataSourceMeta.isGlobalDefault() && (defaultDataSourceMeta = DataSourceProvider.getDefaultDataSourceMeta()) != null) {
            throw new IllegalArgumentException("Duplicate default data sources are specified, namely '" + dataSourceName + "' and '" + DataSourceProvider.getDefaultDataSourceName() + "'");
        }
        DATA_SOURCE_META_MAP.put(dataSourceName, dataSourceMeta);
    }

    public static DataSourceMeta getDefaultDataSourceMeta() {
        if (DATA_SOURCE_META_MAP.isEmpty()) {
            return null;
        }
        for (DataSourceMeta dataSourceMeta : DATA_SOURCE_META_MAP.values()) {
            if (!dataSourceMeta.isGlobalDefault()) continue;
            return dataSourceMeta;
        }
        return null;
    }

    public static DataSourceMeta getDataSourceMeta(Class<?> tableClass) {
        TableMeta tableMeta = TableProvider.getTableMeta(tableClass);
        String bindDataSourceName = tableMeta.getBindDataSourceName();
        return DATA_SOURCE_META_MAP.get(bindDataSourceName);
    }

    public static boolean existDataSource(String dataSourceName) {
        return DATA_SOURCE_META_MAP.containsKey(dataSourceName);
    }

    public static Map<String, String[]> getDataSourceBoundPath() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        DATA_SOURCE_META_MAP.forEach((key, value) -> hashMap.put((String)key, value.getBindBasePackages()));
        return hashMap;
    }

    public static String getDefaultDataSourceName() {
        DataSourceMeta defaultDataSourceMeta = DataSourceProvider.getDefaultDataSourceMeta();
        if (defaultDataSourceMeta == null) {
            return null;
        }
        return DataSourceProvider.getDataSourceName(defaultDataSourceMeta);
    }
}

