/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.datasource.connection;

import com.dynamic.sql.datasource.connection.ConnectionHandle;
import java.sql.Connection;
import javax.sql.DataSource;

public class ConnectionHolder {
    private static ConnectionHandle connectionHandle;

    private ConnectionHolder() {
    }

    public static Connection getConnection(DataSource dataSource) {
        ConnectionHolder.checkConnectionHandle();
        return connectionHandle.getConnection(dataSource);
    }

    public static void releaseConnection(DataSource dataSource, Connection connection) {
        ConnectionHolder.checkConnectionHandle();
        connectionHandle.releaseConnection(dataSource, connection);
    }

    private static void checkConnectionHandle() {
        if (connectionHandle == null) {
            throw new IllegalStateException("ConnectionHandle not provided");
        }
    }

    public static synchronized void setConnectionHandle(ConnectionHandle inputHandle) {
        if (connectionHandle == null && inputHandle != null) {
            connectionHandle = inputHandle;
            return;
        }
        if (connectionHandle != null) {
            throw new IllegalStateException("ConnectionHandle already set");
        }
    }

    public static ConnectionHandle getConnectionHandle() {
        return connectionHandle;
    }
}

