/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.model;

import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.Point;
import com.dynamic.sql.plugins.conversion.AttributeConverter;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.WKBUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Polygon
implements Iterable<Point>,
AttributeConverter<Polygon, byte[]>,
Serializable {
    private static final long serialVersionUID = 345387899390164050L;
    private final List<Point> points;

    private Polygon() {
        this.points = null;
    }

    public Polygon(Point x, Point y, Point z, Point ... others) {
        this(true, x, y, z, others);
    }

    public Polygon(boolean autoClose, Point x, Point y, Point z, Point ... others) {
        if (x == null || y == null || z == null) {
            throw new DynamicSqlException("First three points (x, y, z) must not be null");
        }
        int n = others == null ? 0 : others.length;
        ArrayList<Point> pointsList = new ArrayList<Point>(3 + n);
        pointsList.add(x);
        pointsList.add(y);
        pointsList.add(z);
        if (others != null) {
            Collections.addAll(pointsList, others);
        }
        this.checkClosure(pointsList, autoClose);
        this.points = Collections.unmodifiableList(pointsList);
    }

    public Polygon(Collection<? extends Point> points) {
        this(true, points);
    }

    public Polygon(boolean autoClose, Collection<? extends Point> points) {
        if (CollectionUtils.isEmpty(points) || points.size() < 3) {
            throw new DynamicSqlException("The Points collection provides at least three points");
        }
        ArrayList<Point> pointsClone = new ArrayList<Point>(points.size());
        for (Point point : points) {
            if (point == null) {
                throw new DynamicSqlException("Point must not be null");
            }
            pointsClone.add(point);
        }
        this.checkClosure(pointsClone, autoClose);
        this.points = Collections.unmodifiableList(pointsClone);
    }

    private void checkClosure(List<Point> points, boolean autoClose) {
        Point firstPoint = points.get(0);
        Point lastPoint = points.get(points.size() - 1);
        if (!lastPoint.equals(firstPoint)) {
            if (autoClose) {
                points.add(firstPoint);
            } else {
                throw new DynamicSqlException("The closing point must be the same as the starting point");
            }
        }
    }

    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Iterator<Point> iterator() {
        return this.points.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POLYGON((");
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            sb.append(p.getLongitude()).append(" ").append(p.getLatitude());
            if (i >= this.points.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("))");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.points.equals(polygon.points);
    }

    public int hashCode() {
        return Objects.hash(this.points);
    }

    @Override
    public byte[] convertToDatabaseColumn(Polygon attribute) {
        return WKBUtils.writeWkbBytesFromPolygon(attribute);
    }

    @Override
    public Polygon convertToEntityAttribute(byte[] dbData) {
        return WKBUtils.readPolygonFromWkbBytes(dbData);
    }
}

