/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.debugs;

import com.dynamic.sql.enums.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDebugger {
    private static final Logger log = LoggerFactory.getLogger(SqlDebugger.class);

    private SqlDebugger() {
    }

    public static boolean isLogLevelDisabled(LogLevel level) {
        return !SqlDebugger.isLogLevelEnabled(level);
    }

    public static boolean isLogLevelEnabled(LogLevel level) {
        switch (level) {
            case TRACE: {
                return log.isTraceEnabled();
            }
            case DEBUG: {
                return log.isDebugEnabled();
            }
            case INFO: {
                return log.isInfoEnabled();
            }
            case WARN: {
                return log.isWarnEnabled();
            }
            case ERROR: {
                return log.isErrorEnabled();
            }
        }
        return false;
    }

    public static void printSql(LogLevel level, String text, Object ... args) {
        switch (level) {
            case TRACE: {
                log.trace(text, args);
                break;
            }
            case DEBUG: {
                log.debug(text, args);
                break;
            }
            case INFO: {
                log.info(text, args);
                break;
            }
            case WARN: {
                log.warn(text, args);
                break;
            }
            case ERROR: {
                log.error(text, args);
                break;
            }
            default: {
                log.debug(text, args);
            }
        }
    }
}

