/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.logger.impl;

import com.dynamic.sql.context.properties.SqlLogProperties;
import com.dynamic.sql.plugins.debugs.SqlDebugger;
import com.dynamic.sql.plugins.logger.AbstractSqlLog;
import com.dynamic.sql.plugins.logger.SqlLogContext;
import com.dynamic.sql.plugins.logger.SqlLogResult;
import com.dynamic.sql.plugins.logger.SqlLogResultResolver;
import com.dynamic.sql.plugins.logger.SqlLogger;
import java.util.List;

public class DefaultSqlLogger
extends AbstractSqlLog
implements SqlLogger {
    @Override
    public void beforeSql(SqlLogProperties props, SqlLogContext ctx) {
        if (!props.isEnabled()) {
            return;
        }
        if (SqlDebugger.isLogLevelDisabled(props.getLevel())) {
            return;
        }
        if (!ctx.isIntercepted()) {
            SqlDebugger.printSql(props.getLevel(), "{} -->       !!!!!! : SQL is intercepted.", this.getPrintDataSourceName(props, ctx));
        }
        SqlDebugger.printSql(props.getLevel(), "{} -->     Preparing: {}", this.getPrintDataSourceName(props, ctx), ctx.getPreparedSql().getSql());
        if (props.isPrintParameters()) {
            List<List<Object>> batchParams = ctx.getPreparedSql().getBatchParams();
            for (List<Object> batchParam : batchParams) {
                SqlDebugger.printSql(props.getLevel(), "{} -->    Parameters: {}", this.getPrintDataSourceName(props, ctx), this.assemblyParameters(batchParam));
            }
        }
    }

    @Override
    public void afterSql(SqlLogProperties props, SqlLogContext ctx) {
        if (!props.isEnabled()) {
            return;
        }
        if (SqlDebugger.isLogLevelDisabled(props.getLevel())) {
            return;
        }
        SqlLogResult resolve = SqlLogResultResolver.resolve(props.isEnabled(), ctx.getSqlExecuteType());
        if (resolve == null) {
            return;
        }
        resolve.afterLog(props, ctx);
        if (props.isPrintExecutionTime()) {
            SqlDebugger.printSql(props.getLevel(), "{} <--          Time: {}ms", this.getPrintDataSourceName(props, ctx), ctx.getEndTime() - ctx.getStartTime());
        }
    }
}

