/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.GroupFn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.AbstractAliasHelper;
import com.dynamic.sql.core.column.function.AnonymousFunction;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.RenderContext;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.MysqlWhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.OracleWhereCondition;
import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.dml.select.NestedMeta;
import com.dynamic.sql.core.dml.select.Select;
import com.dynamic.sql.core.dml.select.SelectDsl;
import com.dynamic.sql.core.dml.select.build.GenericSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.MysqlSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.OracleSqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.FromUnionJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.UnionJoin;
import com.dynamic.sql.core.dml.select.order.CustomOrderBy;
import com.dynamic.sql.core.dml.select.order.DefaultOrderBy;
import com.dynamic.sql.core.dml.select.order.OrderBy;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.datasource.DataSourceMeta;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.enums.DbType;
import com.dynamic.sql.enums.JoinTableType;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.enums.SqlExecuteType;
import com.dynamic.sql.enums.UnionType;
import com.dynamic.sql.exception.DynamicSqlException;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.FieldMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.table.view.ViewColumnMeta;
import com.dynamic.sql.table.view.ViewMeta;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    private SqlUtils() {
    }

    public static String getSqlTypeQuotes(SqlDialect sqlDialect) {
        if (sqlDialect == null) {
            throw new DynamicSqlException("Get Sql type quotes not accepting null values");
        }
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "`";
            }
            case ORACLE: 
            case POSTGRESQL: {
                return "\"";
            }
            case SQLSERVER: {
                return "[]";
            }
        }
        throw new DynamicSqlException("Get Sql type quotes not accepting " + (Object)((Object)sqlDialect));
    }

    public static String quoteIdentifier(SqlDialect sqlDialect, String identifier) {
        if (StringUtils.isEmpty(identifier)) {
            return "";
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException("SqlDialect cannot be null");
        }
        String quotes = SqlUtils.getSqlTypeQuotes(sqlDialect);
        if (sqlDialect == SqlDialect.SQLSERVER) {
            return "[" + identifier + "]";
        }
        return quotes + identifier + quotes;
    }

    public static String extractQualifiedAlias(String originalClassCanonicalName, Map<String, TableAliasMapping> aliasTableMap, TableMeta tableMeta) {
        if (aliasTableMap == null && tableMeta != null) {
            return tableMeta.getTableAlias();
        }
        TableAliasMapping alias = aliasTableMap.get(originalClassCanonicalName);
        if (alias != null) {
            String alias1 = alias.getAlias();
            if (alias1 == null && tableMeta != null) {
                return tableMeta.getTableAlias();
            }
            return alias1;
        }
        return tableMeta != null ? SqlUtils.ifAbsentAlias(tableMeta.getTableAlias(), null, aliasTableMap) : null;
    }

    public static <T, F> String extractQualifiedAlias(Fn<T, F> field, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName) {
        return SqlUtils.extractQualifiedAlias(null, field, aliasTableMap, dataSourceName, null);
    }

    public static <T, F> String extractQualifiedAlias(Fn<T, F> field, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName, SqlExecuteType sqlExecuteType) {
        return SqlUtils.extractQualifiedAlias(null, field, aliasTableMap, dataSourceName, sqlExecuteType);
    }

    public static <T, F> String extractQualifiedAlias(String tableAlias, Fn<T, F> field, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName, SqlExecuteType sqlExecuteType) {
        TableMeta tableMeta;
        AbstractAliasHelper abstractAlias;
        Fn<T, F> fn = field;
        aliasTableMap = aliasTableMap == null ? new HashMap<String, TableAliasMapping>() : aliasTableMap;
        DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
        if (dataSourceMeta == null) {
            throw new DynamicSqlException("DataSource not found: " + dataSourceName);
        }
        DbType dbType = dataSourceMeta.getDbType();
        SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
        if (field instanceof AbstractAliasHelper && (abstractAlias = (AbstractAliasHelper)field) instanceof AbstractAliasHelper.TableAliasImpl) {
            tableAlias = SqlUtils.ifAbsentAlias(tableAlias, abstractAlias.getTableAlias(), aliasTableMap);
            if (abstractAlias.getFnColumn() != null) {
                fn = abstractAlias.getFnColumn();
            } else {
                if (SqlUtils.isNeedAlias(sqlExecuteType)) {
                    return SqlUtils.concatenationTableColumn(tableAlias, abstractAlias.getColumnName(), sqlDialect);
                }
                return SqlUtils.quoteIdentifier(sqlDialect, abstractAlias.getColumnName());
            }
        }
        if (field instanceof GroupFn) {
            GroupFn groupFn = (GroupFn)field;
            tableAlias = SqlUtils.ifAbsentAlias(tableAlias, groupFn.getTableAlias(), aliasTableMap);
            if (groupFn.getFn() != null) {
                fn = groupFn.getFn();
            } else {
                if (SqlUtils.isNeedAlias(sqlExecuteType)) {
                    return SqlUtils.concatenationTableColumn(tableAlias, groupFn.getColumnName(), sqlDialect);
                }
                return SqlUtils.quoteIdentifier(sqlDialect, groupFn.getColumnName());
            }
        }
        String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
        if (SqlUtils.isNeedAlias(sqlExecuteType) && tableAlias == null && !aliasTableMap.isEmpty()) {
            TableAliasMapping aliasMapping = (TableAliasMapping)aliasTableMap.get(originalClassCanonicalName);
            if (aliasMapping != null) {
                tableAlias = aliasMapping.getAlias();
            } else {
                if (aliasTableMap.size() == 1) {
                    Map.Entry next = aliasTableMap.entrySet().iterator().next();
                    TableAliasMapping value = (TableAliasMapping)next.getValue();
                    tableAlias = value.getAlias();
                }
                String fieldName = ReflectUtils.fnToFieldName(field);
                return SqlUtils.concatenationTableColumn(tableAlias, fieldName, sqlDialect);
            }
        }
        if ((tableMeta = TableProvider.getTableMeta(originalClassCanonicalName)) == null) {
            return SqlUtils.concatenationTableColumn(tableAlias, ReflectUtils.fnToFieldName(field), sqlDialect);
        }
        ColumnMeta columnMeta = tableMeta.getColumnMeta(ReflectUtils.fnToFieldName(fn));
        tableAlias = SqlUtils.ifAbsentAlias(tableAlias, tableMeta.getTableAlias(), aliasTableMap);
        TableAliasMapping aliasMapping = (TableAliasMapping)aliasTableMap.get(tableAlias);
        String column = SqlUtils.matchBestColumnName(aliasMapping, columnMeta);
        column = SqlUtils.quoteIdentifier(sqlDialect, column);
        if (SqlUtils.isNeedAlias(sqlExecuteType)) {
            return SqlUtils.quoteIdentifier(sqlDialect, tableAlias) + "." + column;
        }
        return column;
    }

    private static String matchBestColumnName(TableAliasMapping aliasMapping, ColumnMeta columnMeta) {
        return aliasMapping != null && aliasMapping.isNestedJoin() ? columnMeta.getField().getName() : columnMeta.getColumnName();
    }

    private static String concatenationTableColumn(String tableAlias, String column, SqlDialect sqlDialect) {
        return StringUtils.isEmpty(tableAlias) ? SqlUtils.quoteIdentifier(sqlDialect, column) : SqlUtils.quoteIdentifier(sqlDialect, tableAlias) + "." + SqlUtils.quoteIdentifier(sqlDialect, column);
    }

    private static String ifAbsentAlias(String oriAlias, String newAlias, Map<String, TableAliasMapping> aliasTableMap) {
        if (oriAlias == null && newAlias != null) {
            return newAlias;
        }
        if (aliasTableMap.containsKey("***")) {
            return aliasTableMap.get("***").getAlias();
        }
        if (oriAlias == null && aliasTableMap.get("**") != null) {
            return aliasTableMap.get("**").getAlias();
        }
        return oriAlias;
    }

    public static boolean isNeedAlias(SqlExecuteType sqlExecuteType) {
        if (sqlExecuteType == null) {
            return true;
        }
        return Objects.equals(sqlExecuteType.getType(), DMLType.SELECT.getType());
    }

    public static String extractQualifiedAliasOrderBy(OrderBy orderBy, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName, Version version, ParameterBinder parameterBinder, Boolean isFromNestedSelect, Class<?> returnClass) {
        DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
        DbType dbType = dataSourceMeta.getDbType();
        SqlDialect sqlDialect = SqlDialect.valueOf(dbType.name());
        StringBuilder sqlBuilder = new StringBuilder(" ");
        if (orderBy instanceof CustomOrderBy) {
            CustomOrderBy customOrderBy = (CustomOrderBy)orderBy;
            sqlBuilder.append(customOrderBy.getOrderingFragment());
        }
        if (orderBy instanceof DefaultOrderBy) {
            DefaultOrderBy defaultOrderBy = (DefaultOrderBy)orderBy;
            if (defaultOrderBy.getFieldFn() != null) {
                FieldMeta fieldMeta;
                String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(defaultOrderBy.getFieldFn());
                TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
                if (tableMeta != null) {
                    fieldMeta = tableMeta.getColumnMetaByFieldName(ReflectUtils.fnToFieldName(defaultOrderBy.getFieldFn()));
                } else {
                    Class<?> aClass = ReflectUtils.loadClass(originalClassCanonicalName);
                    ViewMeta viewMeta = TableProvider.getViewMeta(aClass);
                    fieldMeta = viewMeta.getViewColumnMetaByFieldName(ReflectUtils.fnToFieldName(defaultOrderBy.getFieldFn()));
                }
                String tableAlias = SqlUtils.extractQualifiedAlias(originalClassCanonicalName, aliasTableMap, tableMeta);
                if (Objects.equals(isFromNestedSelect, Boolean.TRUE)) {
                    if (defaultOrderBy.getTableAlias() != null) {
                        sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, defaultOrderBy.getTableAlias())).append(".");
                    }
                    sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, fieldMeta.getField().getName()));
                    return sqlBuilder.toString();
                }
                if (defaultOrderBy.getTableAlias() != null) {
                    sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, defaultOrderBy.getTableAlias())).append(".");
                } else if (defaultOrderBy.getTableAlias() == null && aliasTableMap != null && tableAlias != null) {
                    sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, tableAlias)).append(".");
                }
                sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, fieldMeta.getColumnName()));
            } else if (defaultOrderBy.getColumFunction() != null) {
                ColumFunction columFunction = defaultOrderBy.getColumFunction();
                String functionToString = columFunction.render(new RenderContext(dataSourceName, sqlDialect, version, aliasTableMap));
                parameterBinder.addParameterBinder(columFunction.parameterBinder());
                sqlBuilder.append(functionToString);
            } else {
                if (StringUtils.isNotBlank(orderBy.getTableAlias())) {
                    sqlBuilder.append(orderBy.getTableAlias()).append(".");
                }
                SqlUtils.checkSqlInjection(dataSourceName, returnClass, defaultOrderBy.getColumnName());
                sqlBuilder.append(SqlUtils.quoteIdentifier(sqlDialect, defaultOrderBy.getColumnName()));
            }
        }
        return sqlBuilder.toString();
    }

    private static void checkSqlInjection(String dataSourceName, Class<?> returnClass, String columnName) {
        ViewColumnMeta columnMeta;
        if (returnClass == null) {
            return;
        }
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName);
        if (!schemaProperties.isCheckSqlInjection()) {
            return;
        }
        ViewMeta fieldMeta = TableProvider.getViewMeta(returnClass);
        ViewColumnMeta viewColumnMeta = fieldMeta.getViewColumnMetaByFieldName(columnName);
        ViewColumnMeta viewColumnMeta2 = columnMeta = viewColumnMeta == null ? fieldMeta.getViewColumnMetaByColumnName(columnName) : viewColumnMeta;
        if (columnMeta == null) {
            throw new DynamicSqlException("Order by column name '" + columnName + "' not found in  '" + returnClass.getCanonicalName() + "'. Possible SQL injection risk.");
        }
    }

    public static Object formattedParameter(Object value) {
        return value;
    }

    public static String getSyntaxSelect(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "select";
            }
        }
        return "SELECT";
    }

    public static String getSyntaxUnion(SqlDialect sqlDialect, UnionType unionType) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return unionType == UnionType.UNION ? "union" : "union all";
            }
        }
        return unionType == UnionType.UNION ? "UNION" : "UNION ALL";
    }

    public static String getSyntaxAs(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "as";
            }
            case ORACLE: {
                return "";
            }
        }
        return "AS";
    }

    public static String getSyntaxFrom(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "from";
            }
        }
        return "FROM";
    }

    public static String getSyntaxJoin(SqlDialect sqlDialect, JoinTableType joinTableType) {
        if (joinTableType == JoinTableType.INNER) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "inner join";
                }
            }
            return "INNER JOIN";
        }
        if (joinTableType == JoinTableType.LEFT) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "left join";
                }
            }
            return "LEFT JOIN";
        }
        if (joinTableType == JoinTableType.RIGHT) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "right join";
                }
            }
            return "RIGHT JOIN";
        }
        if (joinTableType == JoinTableType.FULL) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    throw new UnsupportedOperationException("Unsupported associated table query full join type.");
                }
            }
            return "FULL OUTER JOIN";
        }
        if (joinTableType == JoinTableType.CROSS) {
            switch (sqlDialect) {
                case MYSQL: 
                case MARIADB: {
                    return "cross join";
                }
            }
            return "CROSS JOIN";
        }
        throw new UnsupportedOperationException("Unsupported associated table query type.");
    }

    public static String getSyntaxOn(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "on";
            }
        }
        return "ON";
    }

    public static String getSyntaxWhere(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "where";
            }
        }
        return "WHERE";
    }

    public static String getSyntaxLimit(SqlDialect sqlDialect) {
        return "limit";
    }

    public static String getSyntaxExists(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "exists";
            }
        }
        return "EXISTS";
    }

    public static String getSyntaxGroupBy(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "group by";
            }
        }
        return "GROUP BY";
    }

    public static String getSyntaxHaving(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "having";
            }
        }
        return "HAVING";
    }

    public static String getSyntaxOrderBy(SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return "order by";
            }
        }
        return "ORDER BY";
    }

    public static String getSyntaxLogicalOperator(LogicalOperatorType logicalOperatorType, SqlDialect sqlDialect) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return logicalOperatorType.name().toLowerCase();
            }
        }
        return logicalOperatorType.name();
    }

    public static <T extends GenericWhereCondition> T matchDialectCondition(SqlDialect sqlDialect, Version version, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName) {
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return (T)new MysqlWhereCondition(version, aliasTableMap, dataSourceName);
            }
            case ORACLE: {
                return (T)new OracleWhereCondition(version, aliasTableMap, dataSourceName);
            }
        }
        return (T)new GenericWhereCondition(version, aliasTableMap, dataSourceName);
    }

    public static SqlDialect getSqlDialect(Class<?> fromTableClass) {
        TableMeta tableMeta = TableProvider.getTableMeta(fromTableClass);
        if (tableMeta == null) {
            throw new DynamicSqlException("\u4e0d\u5b58\u5728\u8868\u5143\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7c7b\u662f\u5426\u6b63\u786e\u6ce8\u518c\u3002\u4f8b\u5982\u7c7b\u540d\u672a\u4f7f\u7528@Table\u6ce8\u89e3\u6807\u8bb0\uff0c\u6216\u8005\u672a\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ce8\u518c\u3002\u9519\u8bef\u53d1\u751f\u7684\u8868\u7c7b\u540d\uff1a" + fromTableClass.getName());
        }
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        return schemaProperties.getSqlDialect();
    }

    public static <C extends WhereCondition<C>> SqlSelectBuilder matchSqlSelectBuilder(SelectSpecification selectSpecification, Map<String, TableAliasMapping> aliasTableMap) {
        SqlDialect sqlDialect;
        NestedMeta nestedMeta = selectSpecification.getNestedMeta();
        SqlDialect sqlDialect2 = sqlDialect = nestedMeta == null ? null : nestedMeta.getSqlDialect();
        if (sqlDialect == null) {
            JoinTable joinTable = selectSpecification.getJoinTables().get(0);
            if (joinTable instanceof FromNestedJoin) {
                FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
                NestedJoin nestedJoin = fromNestedJoin.getNestedJoin();
                sqlDialect = SqlUtils.nestedJoinSqlDialect(nestedJoin);
            }
            if (joinTable instanceof NestedJoin) {
                NestedJoin nestedJoin = (NestedJoin)joinTable;
                sqlDialect = SqlUtils.nestedJoinSqlDialect(nestedJoin);
            }
            if (joinTable instanceof FromUnionJoin) {
                FromUnionJoin fromUnionJoin = (FromUnionJoin)joinTable;
                UnionJoin unionJoin = fromUnionJoin.getUnionJoin();
                SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(unionJoin.getNestedSelects()[0]);
                Class<?> guessTheTargetClass = sqlStatementWrapper.getGuessTheTargetClass();
                fromUnionJoin.setTableClass(guessTheTargetClass);
                sqlDialect = SchemaContextHolder.getSchemaProperties(sqlStatementWrapper.getDataSourceName()).getSqlDialect();
            }
            if (sqlDialect == null) {
                sqlDialect = SqlUtils.getSqlDialect(joinTable.getTableClass());
            }
        }
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return new MysqlSqlSelectBuilder(selectSpecification, aliasTableMap);
            }
            case ORACLE: {
                return new OracleSqlSelectBuilder(selectSpecification, aliasTableMap);
            }
        }
        return new GenericSqlSelectBuilder(selectSpecification, aliasTableMap);
    }

    public static SqlStatementSelectWrapper executeNestedSelect(SelectDsl nestedSelectConsumer) {
        return SqlUtils.executeNestedSelect(null, nestedSelectConsumer);
    }

    public static SqlStatementSelectWrapper executeNestedSelect(NestedMeta nestedMeta, SelectDsl nestedSelectConsumer) {
        return SqlUtils.executeNestedSelect(nestedMeta, nestedSelectConsumer, new HashMap<String, TableAliasMapping>());
    }

    public static SqlStatementSelectWrapper executeNestedSelect(NestedMeta nestedMeta, SelectDsl nestedSelectConsumer, Map<String, TableAliasMapping> aliasTableMap) {
        Select select = new Select(nestedMeta);
        AbstractColumnReference columnReference = select.loadColumReference();
        nestedSelectConsumer.accept(columnReference);
        SqlSelectBuilder nestedSqlBuilder = SqlUtils.matchSqlSelectBuilder(select.getSelectSpecification(), aliasTableMap);
        return nestedSqlBuilder.build(null);
    }

    private static SqlDialect nestedJoinSqlDialect(NestedJoin nestedJoin) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedJoin.getNestedSelect());
        nestedJoin.setSqlStatementWrapper(sqlStatementWrapper);
        return SchemaContextHolder.getSchemaProperties(sqlStatementWrapper.getDataSourceName()).getSqlDialect();
    }

    public static PreparedSql parsePreparedObject(SqlStatementWrapper sqlStatementWrapper) {
        SqlStatementWrapper.BatchType batchType = sqlStatementWrapper.getBatchType();
        if (batchType == null) {
            StringBuilder rawSql = sqlStatementWrapper.getRawSql();
            ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
            return SqlUtils.parsePreparedObject(rawSql, parameterBinder);
        }
        PreparedSql preparedSql = new PreparedSql(sqlStatementWrapper.getRawSql().toString());
        if (batchType == SqlStatementWrapper.BatchType.BATCH) {
            List<ParameterBinder> batchParameterBinders = sqlStatementWrapper.getBatchParameterBinders();
            for (ParameterBinder batchParameterBinder : batchParameterBinders) {
                List<Object> param = batchParameterBinder.getValues().stream().map(SqlUtils::formattedParameter).collect(Collectors.toList());
                preparedSql.addBatchParams(param);
            }
            return preparedSql;
        }
        List<ParameterBinder> batchParameterBinders = sqlStatementWrapper.getBatchParameterBinders();
        ArrayList<Object> params = new ArrayList<Object>();
        for (ParameterBinder batchParameterBinder : batchParameterBinders) {
            List param = batchParameterBinder.getValues().stream().map(SqlUtils::formattedParameter).collect(Collectors.toList());
            params.addAll(param);
        }
        preparedSql.addBatchParams(params);
        return preparedSql;
    }

    public static PreparedSql parsePreparedObject(StringBuilder rawSql, ParameterBinder parameterBinder) {
        StringBuilder modifiedSql = new StringBuilder(rawSql);
        Pattern uuidPattern = Pattern.compile(":[0-9a-f]{32}");
        Matcher matcher = uuidPattern.matcher(rawSql);
        ArrayList<Object> params = new ArrayList<Object>();
        while (matcher.find()) {
            String placeholder = matcher.group();
            if (!parameterBinder.contains(placeholder)) continue;
            int start = matcher.start();
            int end = matcher.end();
            Object formattedParameter = SqlUtils.formattedParameter(parameterBinder.getValue(placeholder));
            if (formattedParameter instanceof AnonymousFunction) {
                AnonymousFunction anonymousFunction = (AnonymousFunction)formattedParameter;
                PreparedSql functionPreparedSql = SqlUtils.parsePreparedObject(new StringBuilder(anonymousFunction.getFunctionToString()), anonymousFunction.parameterBinder());
                params.addAll(functionPreparedSql.getParams());
                modifiedSql.replace(start, end, functionPreparedSql.getSql());
            } else {
                params.add(formattedParameter);
                modifiedSql.replace(start, end, "?");
            }
            matcher = uuidPattern.matcher(modifiedSql);
        }
        return new PreparedSql(modifiedSql.toString(), params);
    }

    public static String registerValueWithKey(ParameterBinder parameters, Object value) {
        return SqlUtils.registerValueWithKey(parameters, null, value, null);
    }

    public static String registerValueWithKey(ParameterBinder parameters, Fn<?, ?> fn, Object value, SqlDialect sqlDialect) {
        String key = SqlUtils.generateBindingKey();
        if (value == null) {
            parameters.add(key, value);
            return key;
        }
        if (value.getClass() == YearMonth.class) {
            parameters.add(key, value.toString());
            return key;
        }
        if (fn == null) {
            parameters.add(key, value);
            return key;
        }
        if (fn instanceof AbstractAliasHelper) {
            parameters.add(key, value);
            return key;
        }
        FieldMeta fieldMeta = SqlUtils.getFieldMeta(fn);
        if (fieldMeta instanceof ViewColumnMeta && sqlDialect == null) {
            throw new DynamicSqlException(String.format("Can't register value with key: %s, Because it cannot match any data source.", key));
        }
        if (fieldMeta instanceof ColumnMeta && sqlDialect == null) {
            String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
            TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
            SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
            sqlDialect = schemaProperties.getSqlDialect();
        }
        parameters.add(key, ConverterUtils.convertToDatabaseColumn(sqlDialect, fieldMeta, value));
        return key;
    }

    public static FieldMeta getFieldMeta(Fn<?, ?> fn) {
        String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
        String fieldName = ReflectUtils.fnToFieldName(fn);
        TableMeta tableMeta = TableProvider.getTableMeta(originalClassCanonicalName);
        if (tableMeta == null) {
            ViewMeta viewMeta = TableProvider.getViewMeta(ReflectUtils.loadClass(originalClassCanonicalName));
            return viewMeta.getViewColumnMetaByFieldName(fieldName);
        }
        return tableMeta.getColumnMetaByFieldName(fieldName);
    }

    public static String generateBindingKey() {
        return ":" + UUID.randomUUID().toString().replace("-", "");
    }

    public static void close(Connection connection, ResultSet resultSet, Statement statement) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("Connection closed abnormally.", (Throwable)e);
            }
        }
        SqlUtils.close(resultSet, statement);
    }

    public static void close(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error("ResultSet closed abnormally.", (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.error("Statement closed abnormally.", (Throwable)e);
            }
        }
    }

    public static Version databaseProductVersion(DbType dbType, String databaseProductVersion) {
        int i;
        if (dbType == DbType.ORACLE && (i = databaseProductVersion.indexOf("Version")) != -1) {
            databaseProductVersion = databaseProductVersion.substring(i + "Version".length()).trim();
        }
        String[] split = databaseProductVersion.split("\\.");
        Integer majorVersionNumber = 0;
        if (split.length >= 1) {
            majorVersionNumber = Integer.parseInt(split[0]);
        }
        Integer minorVersionNumber = 0;
        if (split.length >= 2) {
            minorVersionNumber = Integer.parseInt(split[1]);
        }
        Integer patchVersionNumber = 0;
        if (split.length >= 3) {
            String string = split[2];
            patchVersionNumber = string.contains("-") ? Integer.valueOf(Integer.parseInt(string.substring(0, string.indexOf("-")))) : Integer.valueOf(Integer.parseInt(string));
        }
        return new Version(majorVersionNumber, minorVersionNumber, patchVersionNumber);
    }
}

