/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy;

import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.OnlySelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.impl.SQLOrderSelectImpl;
import com.easy.query.core.proxy.impl.SQLSelectAsImpl;
import com.easy.query.core.proxy.impl.SQLSelectImpl;
import com.easy.query.core.proxy.set.DSLUpdateSet;
import com.easy.query.core.proxy.sql.Select;

public interface SQLSelectExpression
extends TablePropColumn,
DSLUpdateSet {
    public static final SQLSelectExpression empty = new SQLSelectImpl(x -> {});

    default public void asc() {
        this.asc(true);
    }

    default public void asc(boolean condition) {
        if (condition) {
            this.getEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(true);
                s.column(this.getTable(), this.getValue());
            }));
        }
    }

    default public void desc() {
        this.desc(true);
    }

    default public void desc(boolean condition) {
        if (condition) {
            this.getEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(false);
                s.column(this.getTable(), this.getValue());
            }));
        }
    }

    default public SQLSelectAsExpression as(TablePropColumn propColumn) {
        return this.as(propColumn.getValue());
    }

    default public SQLSelectAsExpression as(String propertyAlias) {
        return new SQLSelectAsImpl(s -> s.columnAs(this.getTable(), this.getValue(), propertyAlias), s -> s.columnAs(this.getTable(), this.getValue(), propertyAlias), s -> {
            throw new UnsupportedOperationException();
        });
    }

    default public SQLSelectExpression _concat(SQLSelectExpression ... sqlSelectAses) {
        return this._concat(true, sqlSelectAses);
    }

    default public SQLSelectExpression _concat(boolean condition, SQLSelectExpression ... sqlSelectAs) {
        if (condition) {
            SQLSelectExpression expression = Select.of(sqlSelectAs);
            return new SQLSelectImpl(x -> {
                this.accept((Selector)x);
                expression.accept((Selector)x);
            });
        }
        return empty;
    }

    default public void accept(Selector s) {
        TableAvailable table = this.getTable();
        String value = this.getValue();
        if (table != null && value != null) {
            s.column(table, value);
        }
    }

    default public void accept(AsSelector s) {
        TableAvailable table = this.getTable();
        String value = this.getValue();
        if (table != null && value != null) {
            s.column(table, value);
        }
    }

    default public void accept(OnlySelector s) {
        s.column(this.getTable(), this.getValue());
    }
}

